/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.projectiles.overflow;

import com.gametechbc.traveloptics.api.entity.SyncedAoeEntity;
import com.gametechbc.traveloptics.api.utils.TOGeneralUtils;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.init.TravelopticsEntities;
import com.gametechbc.traveloptics.util.TravelopticsParticleHelper;
import com.github.L_Ender.cataclysm.client.particle.Custom_Poof_Particle;
import com.github.L_Ender.cataclysm.client.particle.Not_Spin_TrailParticle;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FloodPoolEntity
extends SyncedAoeEntity
implements AntiMagicSusceptible {
    private static final EntityDataAccessor<Float> DATA_FOG_HEIGHT = SynchedEntityData.m_135353_(FloodPoolEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_STAGE = SynchedEntityData.m_135353_(FloodPoolEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int STAGE_WINDUP = 0;
    private static final int STAGE_ACTIVE = 1;
    private static final int STAGE_GROWING = 2;
    private static final int WINDUP_DURATION = 100;
    private static final int ACTIVE_DURATION = 80;
    private static final int GROWTH_START = 180;
    private static final float FOG_HEIGHT_INCREMENT = 0.5f;
    private static final float MAX_FOG_HEIGHT = 1.5f;
    private float currentFogHeight = 0.5f;
    private List<Vec3> eruptionPoints = new ArrayList<Vec3>();
    private static final String WATER_COLOR = "#57acdd";
    private int minWetAmplifier = 0;
    private int maxWetAmplifier = 3;
    private boolean shockwaveComplete = false;

    public FloodPoolEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
        this.setCircular();
        this.f_19794_ = true;
        this.f_19850_ = false;
        this.reapplicationDelay = 30;
    }

    public FloodPoolEntity(Level level) {
        this((EntityType<? extends Projectile>)((EntityType)TravelopticsEntities.FLOOD_POOL_ENTITY.get()), level);
        this.reapplicationDelay = 30;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_FOG_HEIGHT, (Object)Float.valueOf(0.5f));
        this.m_20088_().m_135372_(DATA_STAGE, (Object)0);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.m_9236_().f_46443_) {
            this.initializeEruptionPoints();
        }
    }

    private void initializeEruptionPoints() {
        float radius = this.getRadius();
        int pointCount = Math.max(1, (int)(radius / 2.0f));
        for (int i = 0; i < pointCount; ++i) {
            float distance = radius * (0.2f + this.f_19796_.m_188501_() * 0.8f);
            float angle = this.f_19796_.m_188501_() * 6.283185f;
            double offsetX = distance * Mth.m_14089_((float)angle);
            double offsetZ = distance * Mth.m_14031_((float)angle);
            Vec3 point = new Vec3(this.m_20185_() + offsetX, this.m_20186_(), this.m_20189_() + offsetZ);
            this.eruptionPoints.add(point);
        }
    }

    public void setFogHeight(float fogHeight) {
        if (!this.m_9236_().f_46443_) {
            this.m_20088_().m_135381_(DATA_FOG_HEIGHT, (Object)Float.valueOf(Mth.m_14036_((float)fogHeight, (float)0.5f, (float)1.5f)));
        }
    }

    public float getFogHeight() {
        return ((Float)this.m_20088_().m_135370_(DATA_FOG_HEIGHT)).floatValue();
    }

    private void setStage(int stage) {
        if (!this.m_9236_().f_46443_) {
            this.m_20088_().m_135381_(DATA_STAGE, (Object)stage);
        }
    }

    public int getStage() {
        return (Integer)this.m_20088_().m_135370_(DATA_STAGE);
    }

    public int getMinWetAmplifier() {
        return this.minWetAmplifier;
    }

    public void setMinWetAmplifier(int minWetAmplifier) {
        this.minWetAmplifier = minWetAmplifier;
    }

    public int getMaxWetAmplifier() {
        return this.maxWetAmplifier;
    }

    public void setMaxWetAmplifier(int maxWetAmplifier) {
        this.maxWetAmplifier = maxWetAmplifier;
    }

    private int calculateWetAmplifier() {
        int duration = this.getDuration();
        if (duration <= 0) {
            return this.minWetAmplifier;
        }
        float progress = (float)this.f_19797_ / (float)duration;
        progress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
        return this.minWetAmplifier + Math.round((float)(this.maxWetAmplifier - this.minWetAmplifier) * progress);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            int growthTicks;
            if (this.f_19797_ == 100) {
                this.setStage(1);
            } else if (this.f_19797_ == 180) {
                this.setStage(2);
            }
            if (this.getStage() == 2 && (growthTicks = this.f_19797_ - 180) % 40 == 0 && this.currentFogHeight < 1.5f) {
                this.currentFogHeight = Math.min(this.currentFogHeight + 0.5f, 1.5f);
                this.setFogHeight(this.currentFogHeight);
            }
            if (!this.shockwaveComplete && this.f_19797_ == 1) {
                this.spawnInwardShockwave();
                this.shockwaveComplete = true;
            }
        } else {
            int stage = this.getStage();
            this.spawnEruptionEffects();
            if (stage != 0) {
                this.spawnFloodFogParticles();
            }
        }
    }

    private void spawnInwardShockwave() {
        float radius = this.getRadius();
        Vec3 center = this.m_20182_();
        int ringCount = Math.max(5, (int)(radius / 1.5f));
        for (int ring = 0; ring < ringCount; ++ring) {
            float ringRadius = radius - (float)ring * (radius / (float)ringCount);
            if (ringRadius < 0.5f) continue;
            this.spawnShockwaveRing(center, ringRadius);
        }
    }

    private void spawnShockwaveRing(Vec3 center, float ringRadius) {
        float circumference = ringRadius * 2.0f * (float)Math.PI;
        int blockCount = Mth.m_14045_((int)((int)(circumference / 1.5f)), (int)6, (int)40);
        float anglePerBlock = (float)Math.PI * 2 / (float)blockCount;
        for (int i = 0; i < blockCount; ++i) {
            Vec3 offset = new Vec3((double)(ringRadius * Mth.m_14089_((float)(anglePerBlock * (float)i))), 0.0, (double)(ringRadius * Mth.m_14031_((float)(anglePerBlock * (float)i))));
            BlockPos blockPos = BlockPos.m_274446_((Position)Utils.moveToRelativeGroundLevel((Level)this.m_9236_(), (Vec3)center.m_82549_(offset), (int)3)).m_7495_();
            if (!this.m_9236_().m_8055_(blockPos).m_60783_((BlockGetter)this.m_9236_(), blockPos, Direction.UP)) continue;
            float velocity = 0.12f + this.f_19796_.m_188501_() * 0.08f;
            Utils.createTremorBlock((Level)this.m_9236_(), (BlockPos)blockPos, (float)velocity);
        }
    }

    @Override
    protected Vec3 getInflation() {
        return new Vec3(0.0, 1.5, 0.0);
    }

    @Override
    protected boolean canHitTargetForGroundContext(LivingEntity target) {
        if (this.getStage() == 0) {
            return false;
        }
        double targetHeightDiff = target.m_20186_() - this.m_20186_();
        return targetHeightDiff >= 0.0 && targetHeightDiff <= 1.5;
    }

    @Override
    public void applyEffect(LivingEntity target) {
        if (this.getStage() == 0) {
            return;
        }
        int wetAmplifier = this.calculateWetAmplifier();
        target.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.WET.get(), 100, wetAmplifier, false, false, true));
    }

    private void spawnEruptionEffects() {
        if (this.eruptionPoints.isEmpty()) {
            this.initializeEruptionPointsClient();
        }
        boolean isGrowing = this.getStage() == 2;
        float durationProgress = (float)this.f_19797_ / (float)this.getDuration();
        float intensityMultiplier = isGrowing ? 1.0f + durationProgress * 1.5f : 1.0f;
        for (Vec3 point : this.eruptionPoints) {
            float spawnChance;
            float f = spawnChance = isGrowing ? 0.85f : 0.75f;
            if (!(this.f_19796_.m_188501_() < spawnChance)) continue;
            this.spawnGroundEruption(point, intensityMultiplier, isGrowing);
        }
    }

    private void initializeEruptionPointsClient() {
        float radius = this.getRadius();
        int pointCount = Math.max(1, (int)(radius / 2.0f));
        for (int i = 0; i < pointCount; ++i) {
            float distance = radius * (0.2f + this.f_19796_.m_188501_() * 0.8f);
            float angle = this.f_19796_.m_188501_() * 6.283185f;
            double offsetX = distance * Mth.m_14089_((float)angle);
            double offsetZ = distance * Mth.m_14031_((float)angle);
            Vec3 point = new Vec3(this.m_20185_() + offsetX, this.m_20186_(), this.m_20189_() + offsetZ);
            this.eruptionPoints.add(point);
        }
    }

    private void spawnGroundEruption(Vec3 point, float intensityMultiplier, boolean isGrowing) {
        double motionX;
        double particleZ;
        double particleY;
        int i;
        if (!isGrowing) {
            int trailCount = Math.round((1.5f + (float)this.f_19796_.m_188503_(2)) * intensityMultiplier);
            for (i = 0; i < trailCount; ++i) {
                float angle = this.f_19796_.m_188501_() * 6.283185f;
                float velocity = (0.9f + this.f_19796_.m_188501_() * 0.7f) * intensityMultiplier;
                double extraX = point.f_82479_ + (double)velocity * 0.3 * (double)Mth.m_14089_((float)angle);
                double extraY = point.f_82480_ + (double)((1.2f + this.f_19796_.m_188501_() * 1.4f) * intensityMultiplier);
                double extraZ = point.f_82481_ + (double)velocity * 0.3 * (double)Mth.m_14031_((float)angle);
                float red = (float)TOGeneralUtils.hexToRed(WATER_COLOR) / 255.0f;
                float green = (float)TOGeneralUtils.hexToGreen(WATER_COLOR) / 255.0f;
                float blue = (float)TOGeneralUtils.hexToBlue(WATER_COLOR) / 255.0f;
                this.m_9236_().m_7106_((ParticleOptions)new Not_Spin_TrailParticle.NSTData(red, green, blue, 0.05f, 0.75f, 0.5f, 0.0, 45 + this.f_19796_.m_188503_(25)), point.f_82479_, point.f_82480_ + 0.1, point.f_82481_, extraX, extraY, extraZ);
            }
        }
        float f = this.f_19796_.m_188501_();
        float f2 = isGrowing ? 0.4f : 0.35f;
        if (f < f2) {
            int bubbleCount = Math.round((isGrowing ? 2.0f : 1.2f) + (float)this.f_19796_.m_188503_(isGrowing ? 3 : 2)) * (int)intensityMultiplier;
            for (i = 0; i < bubbleCount; ++i) {
                double particleX = point.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 0.6;
                particleY = point.f_82480_ + 0.1 + this.f_19796_.m_188500_() * 0.3;
                particleZ = point.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 0.6;
                motionX = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                double motionY = (0.2 + this.f_19796_.m_188500_() * 0.35) * (double)intensityMultiplier;
                double motionZ = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                this.m_9236_().m_7106_(TravelopticsParticleHelper.WATER_BUBBLE, particleX, particleY, particleZ, motionX, motionY, motionZ);
            }
        }
        if (!isGrowing && this.f_19796_.m_188501_() < 0.28f) {
            int sparkCount = Math.round((0.8f + (float)this.f_19796_.m_188503_(2)) * intensityMultiplier);
            for (i = 0; i < sparkCount; ++i) {
                double particleX = point.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 0.4;
                particleY = point.f_82480_ + 0.2 + this.f_19796_.m_188500_() * 0.35;
                particleZ = point.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 0.4;
                motionX = (this.f_19796_.m_188500_() - 0.5) * 0.25;
                double motionY = (0.25 + this.f_19796_.m_188500_() * 0.35) * (double)intensityMultiplier;
                double motionZ = (this.f_19796_.m_188500_() - 0.5) * 0.25;
                this.m_9236_().m_7106_(TravelopticsParticleHelper.WATER_SPARKS, particleX, particleY, particleZ, motionX, motionY, motionZ);
            }
        }
        float f3 = this.f_19796_.m_188501_();
        float f4 = isGrowing ? 0.32f : 0.24f;
        if (f3 < f4) {
            int foamCount = Math.round((isGrowing ? 1.5f : 1.2f) + (float)this.f_19796_.m_188503_(isGrowing ? 2 : 2)) * (int)intensityMultiplier;
            for (i = 0; i < foamCount; ++i) {
                double particleX = point.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 0.7;
                particleY = point.f_82480_ + 0.15 + this.f_19796_.m_188500_() * 0.35;
                particleZ = point.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 0.7;
                int rand = this.f_19796_.m_188503_(30) - 15;
                int r = Math.max(0, Math.min(255, TOGeneralUtils.hexToRed(WATER_COLOR) + rand));
                int g = Math.max(0, Math.min(255, TOGeneralUtils.hexToGreen(WATER_COLOR) + rand));
                int b = Math.max(0, Math.min(255, TOGeneralUtils.hexToBlue(WATER_COLOR) + rand));
                double motionX2 = (this.f_19796_.m_188500_() - 0.5) * 0.4;
                double motionY = (0.12 + this.f_19796_.m_188500_() * 0.25) * (double)intensityMultiplier;
                double motionZ = (this.f_19796_.m_188500_() - 0.5) * 0.4;
                this.m_9236_().m_7106_((ParticleOptions)new Custom_Poof_Particle.PoofData(r, g, b, 0.3f), particleX, particleY, particleZ, motionX2, motionY, motionZ);
            }
        }
    }

    private void spawnFloodFogParticles() {
        float radius = this.getRadius();
        int particleCount = Math.max(1, (int)(radius / 4.5f));
        float fogHeight = this.getFogHeight();
        float effectiveFogHeight = fogHeight >= 1.5f ? fogHeight * 0.75f : fogHeight;
        for (int i = 0; i < particleCount; ++i) {
            float distance = radius * (1.0f - this.f_19796_.m_188501_() * this.f_19796_.m_188501_());
            float theta = this.f_19796_.m_188501_() * 6.283185f;
            double offsetX = distance * Mth.m_14089_((float)theta);
            double offsetZ = distance * Mth.m_14031_((float)theta);
            double offsetY = this.f_19796_.m_188500_() * (double)effectiveFogHeight;
            this.m_9236_().m_7106_(TravelopticsParticleHelper.OVERFLOW_FOG, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public void onAntiMagic(MagicData playerMagicData) {
        this.m_146870_();
    }

    @Override
    public float getParticleCount() {
        return 0.0f;
    }

    @Override
    public Optional<ParticleOptions> getParticle() {
        return Optional.empty();
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("CurrentFogHeight", this.currentFogHeight);
        compound.m_128350_("FogHeight", this.getFogHeight());
        compound.m_128405_("Stage", this.getStage());
        compound.m_128405_("MinWetAmplifier", this.minWetAmplifier);
        compound.m_128405_("MaxWetAmplifier", this.maxWetAmplifier);
        compound.m_128379_("ShockwaveComplete", this.shockwaveComplete);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("CurrentFogHeight")) {
            this.currentFogHeight = compound.m_128457_("CurrentFogHeight");
        }
        if (compound.m_128441_("FogHeight")) {
            this.setFogHeight(compound.m_128457_("FogHeight"));
        }
        if (compound.m_128441_("Stage")) {
            this.setStage(compound.m_128451_("Stage"));
        }
        if (compound.m_128441_("MinWetAmplifier")) {
            this.minWetAmplifier = compound.m_128451_("MinWetAmplifier");
        }
        if (compound.m_128441_("MaxWetAmplifier")) {
            this.maxWetAmplifier = compound.m_128451_("MaxWetAmplifier");
        }
        if (compound.m_128441_("ShockwaveComplete")) {
            this.shockwaveComplete = compound.m_128471_("ShockwaveComplete");
        }
    }
}

