/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.extended_projectiles;

import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.init.TravelopticsSpells;
import com.github.alexmodguy.alexscaves.server.entity.item.WaterBoltEntity;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.PlayMessages;

public class ExtendedWaterBoltEntity
extends WaterBoltEntity {
    private float directDamageAmount;
    private float aoeDamageAmount;
    private float aoeRadius;

    public ExtendedWaterBoltEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        super(spawnEntity, level);
    }

    public ExtendedWaterBoltEntity(EntityType<? extends WaterBoltEntity> type, Level level) {
        super(type, level);
    }

    public ExtendedWaterBoltEntity(Level level, LivingEntity owner, float directDamageAmount, float aoeDamageAmount, float aoeRadius) {
        super(level, owner);
        this.directDamageAmount = directDamageAmount;
        this.aoeDamageAmount = aoeDamageAmount;
        this.aoeRadius = aoeRadius;
    }

    public void setDirectDamageAmount(float directDamageAmount) {
        this.directDamageAmount = directDamageAmount;
    }

    public float getDirectDamageAmount() {
        return this.directDamageAmount;
    }

    public void setAoeDamageAmount(float aoeDamageAmount) {
        this.aoeDamageAmount = aoeDamageAmount;
    }

    public float getAoeDamageAmount() {
        return this.aoeDamageAmount;
    }

    public void setAoeRadius(float aoeRadius) {
        this.aoeRadius = aoeRadius;
    }

    public float getAoeRadius() {
        return this.aoeRadius;
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        if (!this.m_9236_().f_46443_ && !this.m_150171_(hitResult.m_82443_()) && this.f_19797_ > 2) {
            this.applyDirectDamage(hitResult);
            this.applyAOEDamage();
            if (this.getDieIn() == -1) {
                this.setDieIn();
            }
        }
    }

    protected void m_8060_(BlockHitResult blockResult) {
        super.m_8060_(blockResult);
        if (!this.m_9236_().f_46443_ && this.f_19797_ > 2) {
            this.applyAOEDamage();
            if (this.getDieIn() == -1) {
                this.setDieIn();
            }
        }
    }

    protected void applyDirectDamage(EntityHitResult hitResult) {
        Entity hitEntity = hitResult.m_82443_();
        if (hitEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)hitEntity;
            if (!livingEntity.m_9236_().f_46443_) {
                SpellDamageSource damageSource = ((AbstractSpell)TravelopticsSpells.AQUA_MISSILES_SPELL.get()).getDamageSource((Entity)this, this.m_19749_());
                livingEntity.m_6469_((DamageSource)damageSource, this.getDirectDamageAmount());
            }
        }
    }

    protected void applyAOEDamage() {
        List nearbyEntities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_((double)this.getAoeRadius()));
        for (Entity entity : nearbyEntities) {
            LivingEntity owner;
            Entity entity2;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.m_150171_(entity) || (entity2 = this.m_19749_()) instanceof LivingEntity && (this.isAlly(owner = (LivingEntity)entity2, livingEntity) || this.isTamed(livingEntity))) continue;
            SpellDamageSource damageSource = ((AbstractSpell)TravelopticsSpells.AQUA_MISSILES_SPELL.get()).getDamageSource((Entity)this, this.m_19749_());
            livingEntity.m_6469_((DamageSource)damageSource, this.getAoeDamageAmount());
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.WET.get(), 100, 1));
        }
    }

    private boolean isAlly(LivingEntity owner, LivingEntity target) {
        return owner.m_5647_() != null && owner.m_5647_().m_83536_(target.m_5647_());
    }

    private boolean isTamed(LivingEntity target) {
        if (target instanceof TamableAnimal) {
            TamableAnimal tamableAnimal = (TamableAnimal)target;
            return tamableAnimal.m_21824_();
        }
        return false;
    }

    protected int getDieIn() {
        return 0;
    }

    protected void setDieIn() {
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("DirectDamageAmount", this.directDamageAmount);
        tag.m_128350_("AoeDamageAmount", this.aoeDamageAmount);
        tag.m_128350_("AoeRadius", this.aoeRadius);
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("DirectDamageAmount")) {
            this.directDamageAmount = tag.m_128457_("DirectDamageAmount");
        }
        if (tag.m_128441_("AoeDamageAmount")) {
            this.aoeDamageAmount = tag.m_128457_("AoeDamageAmount");
        }
        if (tag.m_128441_("AoeRadius")) {
            this.aoeRadius = tag.m_128457_("AoeRadius");
        }
    }
}

