/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.betterx.bclib.util.JsonFactory;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.ui.ColorUtil;

public class EndPortals {
    public static final class_2960 OVERWORLD_ID = class_1937.field_25179.method_29177();
    private static PortalInfo[] portals;

    public static void loadPortals() {
        JsonArray array;
        JsonObject json;
        File file = new File(FabricLoader.getInstance().getConfigDir().toString(), "betterend/portals.json");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            json = EndPortals.makeDefault(file);
        } else {
            json = JsonFactory.getJsonObject((File)file);
        }
        if (!json.has("portals") || !json.get("portals").isJsonArray()) {
            json = EndPortals.makeDefault(file);
        }
        if ((array = json.get("portals").getAsJsonArray()).size() == 0) {
            json = EndPortals.makeDefault(file);
            array = json.get("portals").getAsJsonArray();
        }
        portals = new PortalInfo[array.size()];
        for (int i = 0; i < portals.length; ++i) {
            EndPortals.portals[i] = new PortalInfo(array.get(i).getAsJsonObject());
        }
    }

    public static int getCount() {
        return MHelper.max((int)(portals.length - 1), (int)1);
    }

    public static class_3218 getWorld(MinecraftServer server, int portalId) {
        if (portalId < 0 || portalId >= portals.length) {
            return server.method_30002();
        }
        return portals[portalId].getWorld(server);
    }

    public static class_2960 getWorldId(int portalId) {
        if (portalId < 0 || portalId >= portals.length) {
            return OVERWORLD_ID;
        }
        return EndPortals.portals[portalId].dimension;
    }

    public static int getPortalIdByItem(class_2960 item) {
        for (int i = 0; i < portals.length; ++i) {
            if (!EndPortals.portals[i].item.equals((Object)item)) continue;
            return i;
        }
        return 0;
    }

    public static int getPortalIdByWorld(class_2960 world) {
        for (int i = 0; i < portals.length; ++i) {
            if (!EndPortals.portals[i].dimension.equals((Object)world)) continue;
            return i;
        }
        return 0;
    }

    public static int getColor(int state) {
        return EndPortals.portals[state].color;
    }

    public static boolean isAvailableItem(class_2960 item) {
        for (PortalInfo portal : portals) {
            if (!portal.item.equals((Object)item)) continue;
            return true;
        }
        return false;
    }

    private static JsonObject makeDefault(File file) {
        JsonObject jsonObject = new JsonObject();
        JsonFactory.storeJson((File)file, (JsonElement)jsonObject);
        JsonArray array = new JsonArray();
        jsonObject.add("portals", (JsonElement)array);
        array.add((JsonElement)EndPortals.makeDefault().toJson());
        JsonFactory.storeJson((File)file, (JsonElement)jsonObject);
        return jsonObject;
    }

    private static PortalInfo makeDefault() {
        return new PortalInfo(new class_2960("minecraft:overworld"), BetterEnd.makeID("eternal_crystal"), 255, 255, 255);
    }

    private static class PortalInfo {
        private final class_2960 dimension;
        private final class_2960 item;
        private final int color;
        private class_3218 world;

        PortalInfo(JsonObject obj) {
            this(new class_2960(JsonFactory.getString((JsonObject)obj, (String)"dimension", (String)"minecraft:overworld")), new class_2960(JsonFactory.getString((JsonObject)obj, (String)"item", (String)"betterend:eternal_crystal")), JsonFactory.getInt((JsonObject)obj, (String)"colorRed", (int)255), JsonFactory.getInt((JsonObject)obj, (String)"colorGreen", (int)255), JsonFactory.getInt((JsonObject)obj, (String)"colorBlue", (int)255));
        }

        PortalInfo(class_2960 dimension, class_2960 item, int r, int g, int b) {
            this.dimension = dimension;
            this.item = item;
            this.color = ColorUtil.color((int)r, (int)g, (int)b);
        }

        class_3218 getWorld(MinecraftServer server) {
            if (this.world != null) {
                return this.world;
            }
            for (class_3218 world : server.method_3738()) {
                if (!world.method_27983().method_29177().equals((Object)this.dimension)) continue;
                this.world = world;
                return world;
            }
            return server.method_30002();
        }

        JsonObject toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("dimension", this.dimension.toString());
            obj.addProperty("item", this.item.toString());
            obj.addProperty("colorRed", (Number)(this.color >> 16 & 0xFF));
            obj.addProperty("colorGreen", (Number)(this.color >> 8 & 0xFF));
            obj.addProperty("colorBlue", (Number)(this.color & 0xFF));
            return obj;
        }
    }
}

