/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.dialog_lib.util;

import com.p1nero.dialog_lib.DialogueLib;
import com.p1nero.dialog_lib.api.block.BlockDialogueExtension;
import com.p1nero.dialog_lib.api.block.IBlockDialogueExtension;
import com.p1nero.dialog_lib.api.entity.EntityDialogueExtension;
import com.p1nero.dialog_lib.api.entity.IEntityDialogueExtension;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public final class AnnotatedInstanceUtil {
    public static List<IEntityDialogueExtension> getModEntityExtensions() {
        return AnnotatedInstanceUtil.getInstances(EntityDialogueExtension.class, IEntityDialogueExtension.class);
    }

    public static List<IBlockDialogueExtension> getModBlockExtensions() {
        return AnnotatedInstanceUtil.getInstances(BlockDialogueExtension.class, IBlockDialogueExtension.class);
    }

    private static <T> List<T> getInstances(Class<?> annotationClass, Class<T> instanceClass) {
        Type annotationType = Type.getType(annotationClass);
        List allScanData = ModList.get().getAllScanData();
        LinkedHashSet<String> extensionClassNames = new LinkedHashSet<String>();
        for (ModFileScanData scanData : allScanData) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                if (!Objects.equals(data.annotationType(), annotationType)) continue;
                String memberName = data.memberName();
                extensionClassNames.add(memberName);
            }
        }
        ArrayList<T> instances = new ArrayList<T>();
        for (String className : extensionClassNames) {
            try {
                Class<?> asmClass = Class.forName(className);
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError e) {
                DialogueLib.LOGGER.error("Failed to load: {}", (Object)className, (Object)e);
            }
        }
        return instances;
    }
}

