/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.dialog_lib.network.packet.serverbound;

import com.p1nero.dialog_lib.DialogueLib;
import com.p1nero.dialog_lib.api.block.custom.IBlockEntityNpc;
import com.p1nero.dialog_lib.events.ServerNpcBlockInteractEvent;
import com.p1nero.dialog_lib.network.packet.BasePacket;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public record HandleNpcBlockPlayerInteractPacket(BlockPos pos, int interactionID) implements BasePacket
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos());
        buf.writeByte(this.interactionID());
    }

    public static HandleNpcBlockPlayerInteractPacket decode(FriendlyByteBuf buf) {
        return new HandleNpcBlockPlayerInteractPacket(buf.m_130135_(), buf.readByte());
    }

    @Override
    public void execute(@Nullable Player playerEntity) {
        if (playerEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
            BlockState blockState = serverPlayer.m_284548_().m_8055_(this.pos);
            ServerNpcBlockInteractEvent event = new ServerNpcBlockInteractEvent(this.pos, blockState, serverPlayer, this.interactionID);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                BlockEntity blockEntity = playerEntity.m_9236_().m_7702_(this.pos);
                if (blockEntity != null && blockEntity instanceof IBlockEntityNpc) {
                    IBlockEntityNpc npcDialogueBlock = (IBlockEntityNpc)blockEntity;
                    npcDialogueBlock.handleNpcInteraction(serverPlayer, this.interactionID);
                }
                DialogueLib.runIfBlockExtensionExist((Player)serverPlayer, blockState, this.pos, iBlockDialogueExtension -> iBlockDialogueExtension.handleNpcInteraction(blockState, this.pos, serverPlayer, this.interactionID()));
            }
        }
    }
}

