/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.dialog_lib.client.screen.builder;

import com.p1nero.dialog_lib.api.component.DialogNode;
import com.p1nero.dialog_lib.api.component.DialogueComponentBuilder;
import com.p1nero.dialog_lib.client.screen.DialogueScreen;
import com.p1nero.dialog_lib.client.screen.component.DialogueOptionComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DialogueScreenBuilder {
    protected DialogueScreen screen;
    protected Component defaultTitle = Component.m_237119_();
    protected Component customTitle;
    @Nullable
    protected Entity entity;
    @Nullable
    protected BlockState blockState;
    @Nullable
    protected BlockPos pos;
    protected DialogueComponentBuilder builder;
    protected DialogNode root;
    protected DialogNode tempNode;
    protected String modId;
    protected Function<String, ? extends DialogueScreen> constructor = DialogueScreen::new;

    public DialogueScreenBuilder(Component defaultTitle, String name, String modId) {
        this.builder = new DialogueComponentBuilder(name, modId);
        this.defaultTitle = defaultTitle;
        this.modId = modId;
    }

    public DialogueScreenBuilder(BlockState blockState, BlockPos pos, String modId) {
        this.builder = new DialogueComponentBuilder(blockState, modId);
        this.blockState = blockState;
        this.pos = pos;
        this.modId = modId;
    }

    public DialogueScreenBuilder(Entity entity, String modId) {
        this.builder = new DialogueComponentBuilder(entity, modId);
        this.entity = entity;
        this.modId = modId;
    }

    public void setConstructor(Function<String, ? extends DialogueScreen> constructor) {
        this.constructor = constructor;
    }

    public void setCustomTitle(Component customTitle) {
        this.customTitle = customTitle;
    }

    public String getModId() {
        return this.modId;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    @Deprecated
    public void setRoot(DialogNode root) {
        this.root = root;
    }

    public void setScreen(DialogueScreen screen) {
        this.screen = screen;
    }

    public DialogNode newNode(int ans) {
        return new DialogNode((Component)this.builder.ans(ans), (Component)Component.m_237119_(), -114514, null);
    }

    public DialogNode newNode(int ans, int opt) {
        return new DialogNode((Component)this.builder.ans(ans), (Component)this.builder.opt(opt), -114514, null);
    }

    public DialogNode newNode(int ans, int opt, Consumer<DialogueScreen> consumer) {
        return new DialogNode((Component)this.builder.ans(ans), (Component)this.builder.opt(opt), -114514, consumer);
    }

    public DialogNode newNode(int ans, int opt, int execute) {
        return new DialogNode((Component)this.builder.ans(ans), (Component)this.builder.opt(opt), execute, null);
    }

    public DialogNode newNode(int ans, int opt, int execute, Consumer<DialogueScreen> consumer) {
        return new DialogNode((Component)this.builder.ans(ans), (Component)this.builder.opt(opt), execute, consumer);
    }

    public DialogNode newFinalNode(int opt) {
        return this.newFinalNode(opt, 0, null);
    }

    public DialogNode newFinalNode(int opt, int returnValue) {
        return this.newFinalNode(opt, returnValue, null);
    }

    public DialogNode newFinalNode(int opt, int returnValue, Consumer<DialogueScreen> consumer) {
        return new DialogNode.FinalNode((Component)this.builder.opt(opt), returnValue, consumer);
    }

    public DialogueComponentBuilder getComponentBuildr() {
        return this.builder;
    }

    public DialogueScreen buildWith(DialogNode customRoot) {
        this.setRoot(customRoot);
        return this.build();
    }

    @Nullable
    public DialogueScreen build() {
        this.screen = this.constructor.apply(this.modId);
        if (this.root == null) {
            return null;
        }
        if (this.entity != null) {
            this.screen.setEntity(this.entity);
        }
        if (this.pos != null && this.blockState != null) {
            this.screen.setBlockState(this.blockState, this.pos);
        }
        if (this.customTitle != null) {
            this.screen.setCustomTitle(this.customTitle);
        }
        this.screen.setDialogueAnswer(this.root.getAnswer());
        ArrayList<DialogueOptionComponent> choiceList = new ArrayList<DialogueOptionComponent>();
        for (DialogNode child : this.root.getChildren()) {
            if (child.getOption() == null) continue;
            choiceList.add(new DialogueOptionComponent(child.getOption().m_6881_(), this.createChoiceButton(child)));
        }
        this.screen.setupDialogueOptions(choiceList);
        return this.screen;
    }

    private Button.OnPress createChoiceButton(DialogNode node) {
        if (node instanceof DialogNode.FinalNode) {
            DialogNode.FinalNode finalNode = (DialogNode.FinalNode)node;
            return button -> {
                if (!this.screen.shouldRenderOption()) {
                    return;
                }
                this.screen.finishChat(finalNode.getReturnValue());
                if (finalNode.canExecute()) {
                    finalNode.execute(this.screen);
                }
            };
        }
        return button -> {
            if (!this.screen.shouldRenderOption()) {
                return;
            }
            if (node.canExecute()) {
                node.execute(this.screen);
            }
            if (node.canExecuteCode()) {
                if (node.getExecuteValue() == 0) {
                    throw new IllegalArgumentException("The return value '0' is used by default. and this will cause conservation stop!");
                }
                this.screen.execute(node.getExecuteValue());
            }
            this.screen.setDialogueAnswer(node.getAnswer());
            ArrayList<DialogueOptionComponent> choiceList = new ArrayList<DialogueOptionComponent>();
            List<DialogNode> options = node.getChildren();
            if (options == null) {
                options = new ArrayList<DialogNode>();
                options.add(new DialogNode.FinalNode((Component)Component.m_237119_(), 0));
            }
            for (DialogNode child : options) {
                choiceList.add(new DialogueOptionComponent(child.getOption().m_6881_(), this.createChoiceButton(child)));
            }
            this.screen.setupDialogueOptions(choiceList);
        };
    }
}

