/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.dialog_lib.capability;

import com.p1nero.dialog_lib.DialogueLib;
import com.p1nero.dialog_lib.api.entity.custom.IEntityNpc;
import com.p1nero.dialog_lib.capability.DialogEntityPatch;
import com.p1nero.dialog_lib.capability.DialogEntityPatchProvider;
import com.p1nero.dialog_lib.network.DialoguePacketHandler;
import com.p1nero.dialog_lib.network.DialoguePacketRelay;
import com.p1nero.dialog_lib.network.packet.clientbound.SyncDialogPlayerDataPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="p1nero_dl")
public class DialogueLibCapabilities {
    public static Capability<DialogEntityPatch> DIALOG_ENTITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<DialogEntityPatch>(){});

    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() != null && (DialogueLib.ENTITY_EXTENSIONS_MAP.containsKey(((Entity)event.getObject()).m_6095_()) || event.getObject() instanceof IEntityNpc) && !((Entity)event.getObject()).getCapability(DIALOG_ENTITY).isPresent()) {
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"p1nero_dl", (String)"dialog_entity_data"), (ICapabilityProvider)new DialogEntityPatchProvider((Entity)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(DialogEntityPatch.class);
    }

    public static DialogEntityPatch getDialogPatch(Entity entity) {
        return (DialogEntityPatch)entity.getCapability(DIALOG_ENTITY).orElse((Object)new DialogEntityPatch(entity));
    }

    @Nullable
    public static Player getConservingPlayer(Entity entity) {
        return DialogueLibCapabilities.getDialogPatch(entity).getCurrentTalkingPlayer();
    }

    public static void setConservingPlayer(Entity entity, @Nullable Player player) {
        DialogueLibCapabilities.getDialogPatch(entity).setConservingPlayer(player);
    }

    public static void syncToClient(@NotNull Entity entity) {
        if (entity.m_9236_() instanceof ServerLevel) {
            DialoguePacketRelay.sendToAll(DialoguePacketHandler.INSTANCE, new SyncDialogPlayerDataPacket(entity.m_19879_(), DialogueLibCapabilities.getDialogPatch(entity).saveNBTData(new CompoundTag())));
        }
    }
}

