/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.dialog_lib.api.entity.custom;

import com.p1nero.dialog_lib.capability.DialogueLibCapabilities;
import com.p1nero.dialog_lib.client.screen.DialogueScreen;
import com.p1nero.dialog_lib.network.DialoguePacketHandler;
import com.p1nero.dialog_lib.network.DialoguePacketRelay;
import com.p1nero.dialog_lib.network.packet.clientbound.NPCEntityDialoguePacket;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IEntityNpc {
    default public Entity asEntity() {
        return (Entity)this;
    }

    default public boolean shouldLookAtConservingPlayer() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void openDialogueScreen(CompoundTag senderData) {
        DialogueScreen dialogueScreen = this.getDialogueScreen(senderData);
        if (dialogueScreen != null) {
            Minecraft.m_91087_().m_91152_((Screen)dialogueScreen);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public DialogueScreen getDialogueScreen(CompoundTag var1);

    public void handleNpcInteraction(ServerPlayer var1, int var2);

    default public void setConversingPlayer(@Nullable Player player) {
        DialogueLibCapabilities.setConservingPlayer(this.asEntity(), player);
    }

    @Nullable
    default public Player getConversingPlayer() {
        return DialogueLibCapabilities.getConservingPlayer(this.asEntity());
    }

    default public void sendDialogTo(ServerPlayer serverPlayer, CompoundTag data) {
        if (this.getConversingPlayer() == null) {
            DialoguePacketRelay.sendToPlayer(DialoguePacketHandler.INSTANCE, new NPCEntityDialoguePacket(((LivingEntity)this).m_19879_(), data), serverPlayer);
            this.setConversingPlayer((Player)serverPlayer);
        }
    }

    default public void forceSendDialogTo(ServerPlayer serverPlayer, CompoundTag data) {
        DialoguePacketRelay.sendToPlayer(DialoguePacketHandler.INSTANCE, new NPCEntityDialoguePacket(((LivingEntity)this).m_19879_(), data), serverPlayer);
        this.setConversingPlayer((Player)serverPlayer);
    }

    default public void sendDialogTo(ServerPlayer serverPlayer) {
        this.sendDialogTo(serverPlayer, this.getServerData());
    }

    default public CompoundTag getServerData() {
        return new CompoundTag();
    }
}

