/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.dialog_lib.api.block;

import com.p1nero.dialog_lib.DialogueLib;
import com.p1nero.dialog_lib.api.entity.EntityDialogueExtension;
import com.p1nero.dialog_lib.client.screen.DialogueScreen;
import com.p1nero.dialog_lib.client.screen.builder.StreamDialogueScreenBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IBlockDialogueExtension<T extends Block> {
    default public String getModId() {
        return this.getClass().getAnnotation(EntityDialogueExtension.class).modId();
    }

    public T getBlock();

    public boolean canInteractWith(Player var1, BlockState var2, BlockPos var3);

    default public boolean shouldCancelInteract(Player player, BlockState currentTalking, BlockPos pos, InteractionHand hand) {
        return true;
    }

    default public void onPlayerInteract(Player player, BlockState currentTalking, BlockPos pos, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            DialogueLib.sendDialog(pos, this.getServerData(serverPlayer, currentTalking, pos, hand, new CompoundTag()), serverPlayer);
        }
    }

    default public CompoundTag getServerData(ServerPlayer player, BlockState currentTalking, BlockPos pos, InteractionHand hand, CompoundTag senderData) {
        return senderData;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void openDialogScreen(LocalPlayer localPlayer, BlockState currentTalking, BlockPos pos, CompoundTag senderData) {
        StreamDialogueScreenBuilder dialogueScreenBuilder = new StreamDialogueScreenBuilder(currentTalking, pos, this.getModId());
        DialogueScreen dialogueScreen = this.getDialogScreen(dialogueScreenBuilder, localPlayer, currentTalking, pos, senderData);
        if (dialogueScreen != null) {
            Minecraft.m_91087_().m_91152_((Screen)dialogueScreen);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public DialogueScreen getDialogScreen(StreamDialogueScreenBuilder var1, LocalPlayer var2, BlockState var3, BlockPos var4, CompoundTag var5);

    public void handleNpcInteraction(BlockState var1, BlockPos var2, ServerPlayer var3, int var4);
}

