console.info('Loading strainers scripts...')

ServerEvents.recipes(event => {

  // Custom Recipes
  event.shaped('strainers:mulch', [' A ', 'ABA', ' A '], { A: '#minecraft:leaves', B: '#minecraft:saplings' }).id('strainers:mulch_from_leaves_and_saplings')

  // Remove Unwanted Strainer Recipes
  event.remove({ id: /strainers:ore_pieces.*/ })
  event.remove({ id: 'strainers:strainer/gravel/purified_gravel' })
  event.remove({ id: 'strainers:strainer/purified_gravel/diamond_ore_piece' })
  event.remove({ id: 'strainers:strainer/purified_gravel/emerald_ore_piece' })
  event.remove({ id: 'strainers:strainer/purified_gravel/silver_ore_piece' })
  event.remove({ id: 'strainers:strainer/purified_gravel/lead_ore_piece' })
  event.remove({ id: 'strainers:strainer/purified_gravel/zinc_ore_piece' })
  event.remove({ id: 'strainers:strainer/purified_gravel/nickel_ore_piece' })
  event.remove({ id: 'strainers:strainer/purified_gravel/uranium_ore_piece' })
  event.remove({ id: 'strainers:strainer/purified_gravel/osmium_ore_piece' })
  event.remove({ id: 'strainers:strainer/purified_gravel/platinum_ore_piece' })
  event.remove({ id: 'strainers:strainer/purified_gravel/aluminum_ore_piece' })
  event.remove({ id: 'strainers:strainer/purified_sand/soul_sand' })
  event.remove({ id: 'strainers:strainer/purified_stone/deepslate' })
  event.remove({ id: 'strainers:strainer/sculk/echo_shard' })

  //Bamboo Mesh
  event.shaped('strainers:bamboo_mesh', ['ASA', 'SAS', 'ASA'], { A: 'minecraft:bamboo', S: 'minecraft:stick' }).id('strainers:bamboo_mesh')

  //Strainers - Tier 1 Straining

  strainerAuto('#minecraft:dirt', 'minecraft:water', 'projectvibrantjourneys:rocks', 0.1, 0.05, 1, 10);
  strainerAuto('#minecraft:dirt', 'minecraft:water', 'projectvibrantjourneys:mossy_rocks', 0.1, 0.05, 1, 10);
  strainerAuto('#minecraft:dirt', 'minecraft:water', 'projectvibrantjourneys:sandstone_rocks', 0.1, 0.05, 1, 10);
  strainerAuto('#minecraft:dirt', 'minecraft:water', 'projectvibrantjourneys:red_sandstone_rocks', 0.1, 0.05, 1, 10);
  strainerAuto('#minecraft:dirt', 'minecraft:water', 'projectvibrantjourneys:ice_chunks', 0.1, 0.05, 1, 10);

  strainerAuto('strainers:purified_gravel', 'minecraft:water', 'strainers:tin_ore_piece', 0.1, 0.05, 1, 10);

  strainerAuto('evolved:tier_2_modularium', 'strainers:purifying_water', 'evolved:tier_3_modularium', 1.0, 1.0, 10, 10);

  strainerAuto('minecraft:leather', 'strainers:purifying_water', 'minecraft:phantom_membrane', 0.1, 0.05, 5, 10);

  strainerAuto('strainers:purified_dirt', 'minecraft:water', 'actuallyadditions:canola_seeds', 0.1, 0.05, 1, 10);
  strainerAuto('strainers:purified_dirt', 'minecraft:water', 'actuallyadditions:coffee_beans', 0.1, 0.05, 1, 10);
  strainerAuto('strainers:purified_dirt', 'minecraft:water', 'actuallyadditions:rice_seeds', 0.1, 0.05, 1, 10);
  strainerAuto('strainers:purified_dirt', 'minecraft:water', 'farmersdelight:cabbage_seeds', 0.1, 0.05, 1, 10);
  strainerAuto('strainers:purified_dirt', 'minecraft:water', 'farmersdelight:tomato_seeds', 0.1, 0.05, 1, 10);
  strainerAuto('strainers:purified_dirt', 'minecraft:water', 'actuallyadditions:flax_seeds', 0.1, 0.05, 1, 10);
  strainerAuto('strainers:purified_dirt', 'minecraft:water', 'minecraft:ink_sac', 0.1, 0.05, 6, 10);

  //Auto Strainer Tier Recipes
  function strainerAuto(input, fluid, item, baseChance, addChance, minTier, maxTier) {
    let results = [];
    for (let tier = minTier; tier <= maxTier; tier++) {
      let chance = baseChance + (tier - minTier) * addChance;
      results.push([item, chance, `#strainers:tier_${tier}_meshes`]);
    }
    return event.recipes.strainers.strainer(Ingredient.of(input), fluid, results);
  }


})