ServerEvents.recipes(event => {
    //Industrial Foregoing - Dissolution Chamber

    // Echo Shard
    event.custom({
        type: 'industrialforegoing:dissolution_chamber',
        input: [
            { item: 'minecraft:sculk' },
            { item: 'minecraft:sculk' },
            { item: 'minecraft:sculk' },
            { item: 'minecraft:sculk' }
        ],
        inputFluid: {
            amount: 100,
            fluid: 'evolved:molten_void'
        },
        output: {
            count: 1,
            id: 'minecraft:echo_shard'
        },
        processingTime: 400
    }).id('evolved:industrialforegoing/echo_shard')

    // Tier 7 Machine Frame
    event.custom({
        type: 'industrialforegoing:dissolution_chamber',
        input: [
            { item: 'pneumaticcraft:plastic' },
            { item: 'evolved:perfect_gem' },
            { item: 'pneumaticcraft:plastic' },
            { item: 'minecraft:nether_brick' },
            { item: 'minecraft:nether_brick' },
            { tag: 'c:ingots/iron' },
            { tag: 'c:gears/gold' },
            { tag: 'c:ingots/iron' }
        ],
        inputFluid: {
            amount: 250,
            fluid: 'pneumaticcraft:plastic'
        },
        output: {
            count: 1,
            id: 'evolved:tier_7_machine_frame'
        },
        processingTime: 300
    }).id('evolved:industrialforegoing/tier_7_machine_frame')

    // Tier 8 Machine Frame
    event.custom({
        type: 'industrialforegoing:dissolution_chamber',
        input: [
            { item: 'pneumaticcraft:plastic' },
            { item: 'evolved:tier_7_machine_frame' },
            { item: 'pneumaticcraft:plastic' },
            { item: 'industrialforegoing:pink_slime_ingot' },
            { item: 'industrialforegoing:pink_slime_ingot' },
            { tag: 'c:ingots/gold' },
            { tag: 'c:gears/diamond' },
            { tag: 'c:ingots/gold' }
        ],
        inputFluid: {
            amount: 250,
            fluid: 'evolved:molten_void'
        },
        output: {
            count: 1,
            id: 'evolved:tier_8_machine_frame'
        },
        processingTime: 250
    }).id('evolved:industrialforegoing/tier_8_machine_frame')

    // Tier 9 Machine Frame
    event.custom({
        type: 'industrialforegoing:dissolution_chamber',
        input: [
            { item: 'pneumaticcraft:plastic' },
            { item: 'evolved:tier_8_machine_frame' },
            { item: 'pneumaticcraft:plastic' },
            { item: 'minecraft:nether_brick' },
            { item: 'minecraft:nether_brick' },
            { tag: 'c:ingots/osmium' },
            { item: 'evolved:kings_jewels' },
            { tag: 'c:ingots/osmium' }
        ],
        inputFluid: {
            amount: 1000,
            fluid: 'evolved:molten_void'
        },
        output: {
            count: 1,
            id: 'evolved:tier_9_machine_frame'
        },
        processingTime: 400
    }).id('evolved:industrialforegoing/tier_9_machine_frame')

    // Pink Slime Ingot
    event.custom({
        type: 'industrialforegoing:dissolution_chamber',
        input: [
            { item: 'industrialforegoing:pink_slime' },
            { item: 'evolved:perfect_gem' },
            { item: 'industrialforegoing:pink_slime' },
            { tag: 'c:ingots/silver' },
            { tag: 'c:ingots/silver' },
            { tag: 'c:ingots/iron' },
            { tag: 'c:ingots/uranium' },
            { tag: 'c:ingots/iron' }
        ],
        inputFluid: {
            amount: 500,
            fluid: 'evolved:molten_void'
        },
        output: {
            count: 1,
            id: 'industrialforegoing:pink_slime_ingot'
        },
        processingTime: 300
    }).id('evolved:industrialforegoing/pink_slime_ingot')

    // Tier 9 Modularium
    event.custom({
        type: 'industrialforegoing:dissolution_chamber',
        input: [
            { item: 'evolved:sculk_powder' },
            { item: 'evolved:tier_8_modularium' },
            { item: 'evolved:sculk_powder' },
            { item: 'industrialforegoing:pink_slime_ingot' },
            { item: 'industrialforegoing:pink_slime_ingot' },
            { item: 'minecraft:echo_shard' },
            { item: 'evolved:perfect_gem' },
            { item: 'minecraft:echo_shard' }
        ],
        inputFluid: {
            amount: 4000,
            fluid: 'industrialforegoing:ether_gas'
        },
        output: {
            count: 1,
            id: 'evolved:tier_9_modularium'
        },
        processingTime: 400
    }).id('evolved:industrialforegoing/tier_9_modularium')

    // Mycelial Reactor (with neoforge condition)
    event.custom({
        'neoforge:conditions': [
            {
                type: 'neoforge:item_exists',
                item: 'industrialforegoing:mycelial_reactor'
            }
        ],
        type: 'industrialforegoing:dissolution_chamber',
        input: [
            { tag: 'c:plastics' },
            { item: 'evolved:tier_10_machine_frame' },
            { tag: 'c:plastics' },
            { item: 'minecraft:netherite_ingot' },
            { item: 'minecraft:netherite_ingot' },
            { tag: 'c:gears/diamond' },
            { item: 'minecraft:heavy_core' },
            { tag: 'c:gears/diamond' }
        ],
        inputFluid: {
            amount: 500,
            fluid: 'industrialforegoing:ether_gas'
        },
        output: {
            count: 1,
            id: 'industrialforegoing:mycelial_reactor'
        },
        processingTime: 600
    }).id('evolved:industrialforegoing/mycelial_reactor')

    // Laser Drill Fluid - Molten Void
    event.custom({
        type: 'industrialforegoing:laser_drill_fluid',
        catalyst: {
            item: 'industrialforegoing:black_laser_lens'
        },
        output: {
            amount: 50,
            fluid: 'evolved:molten_void'
        },
        rarity: [
            {
                biome_filter: {
                    blacklist: [],
                    whitelist: []
                },
                depth_max: 120,
                depth_min: 1,
                dimension_filter: {
                    blacklist: [],
                    whitelist: [
                        'javd:void'
                    ]
                },
                weight: 1000
            }
        ]
    }).id('evolved:industrialforegoing/laser_drill_fluid_molten_void')

    // Stonework Factory - Deepslate
    event.custom({
        type: 'industrialforegoing:stonework_generate',
        lavaConsume: 500,
        lavaNeed: 500,
        output: {
            count: 1,
            id: 'minecraft:deepslate'
        },
        waterConsume: 500,
        waterNeed: 500
    }).id('evolved:industrialforegoing/stonework_deepslate')
})
