const $Registry = Java.loadClass('net.minecraft.core.registries.Registries')
const $TagKey = Java.loadClass('net.minecraft.tags.TagKey')

ItemEvents.rightClicked('evolved:mysterious_eye', event => {
    const { player, level, hand, item } = event

    if (level.clientSide) return

    let structureTag = $TagKey.create($Registry.STRUCTURE, 'evolved:sky_stone_temple')
    let foundPos = level.findNearestMapStructure(structureTag, player.blockPosition(), 100, false)

    if (foundPos != null) {
        // Spawn vanilla ender eye entity pointing to the structure
        let eye = level.createEntity('minecraft:eye_of_ender')
        eye.setPos(player.x, player.eyeY - 0.1, player.z)
        eye.signalTo(foundPos)
        eye.setItem(Item.of('evolved:mysterious_eye'))
        level.addFreshEntity(eye)

        player.swing(hand)
        if (!player.creative) {
            item.count--
        }
    } else {
        player.displayClientMessage(Component.literal('§cNo Sky Stone Temple found nearby!'), true)
    }
})
