/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium._impl.test.tile;

import com.hrznstudio.titanium._impl.test.AssetTestBlock;
import com.hrznstudio.titanium._impl.test.assetsystem.NewAssetProviderTest;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IItemStackQuery;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.PoweredTile;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AssetTestTile
extends PoweredTile<AssetTestTile> {
    @Save
    private SidedInventoryComponent<AssetTestTile> inventory = (SidedInventoryComponent)((InventoryComponent)((Object)new SidedInventoryComponent("inventory", 8, 88, 18, 0).setFacingHandlerPos(-15, 1))).setRange(9, 2).setComponentHarness(this).setInputFilter((stack, integer) -> IItemStackQuery.ANYTHING.test((ItemStack)stack));
    @Save
    private InventoryComponent<AssetTestTile> recipe;
    @Save
    private InventoryComponent<AssetTestTile> fakeOutput;
    @Save
    private SidedInventoryComponent<AssetTestTile> realOutput;
    @Save
    private InventoryComponent<AssetTestTile> randomSlot;
    @Save
    private SidedInventoryComponent<AssetTestTile> fluidInput;
    @Save
    private ProgressBarComponent<AssetTestTile> progressBar;
    @Save
    private SidedFluidTankComponent<AssetTestTile> fluidTank;

    public AssetTestTile(BlockPos pos, BlockState state) {
        super((BasicTileBlock)AssetTestBlock.TEST.block().get(), (BlockEntityType)AssetTestBlock.TEST.type().get(), pos, state);
        this.addInventory(this.inventory);
        this.recipe = new InventoryComponent("recipe", 10, 20, 9).setRange(3, 3).setComponentHarness(this).setInputFilter((stack, integer) -> IItemStackQuery.ANYTHING.test((ItemStack)stack));
        this.addInventory(this.recipe);
        this.fakeOutput = new InventoryComponent("fake_output", 80, 51, 1).setInputFilter((stack, integer) -> IItemStackQuery.ANYTHING.test((ItemStack)stack));
        this.addInventory(this.fakeOutput);
        this.realOutput = (SidedInventoryComponent)((InventoryComponent)((Object)new SidedInventoryComponent("real_output", 120, 56, 1, 0).setFacingHandlerPos(-15, 16))).setInputFilter((stack, integer) -> IItemStackQuery.ANYTHING.test((ItemStack)stack));
        this.addInventory(this.realOutput);
        this.randomSlot = new InventoryComponent("random_slot", 83, 20, 1).setInputFilter((stack, integer) -> IItemStackQuery.ANYTHING.test((ItemStack)stack));
        this.addInventory(this.randomSlot);
        this.fluidInput = (SidedInventoryComponent)((InventoryComponent)((Object)new SidedInventoryComponent("fluid_input", 119, 20, 1, 0).setFacingHandlerPos(-15, 31))).setSlotLimit(1).setComponentHarness(this);
        this.addInventory(this.fluidInput);
        this.progressBar = new ProgressBarComponent<AssetTestTile>(98, 50, 500).setCanIncrease(tileEntity -> true).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP);
        this.addProgressBar(this.progressBar);
        this.fluidTank = (SidedFluidTankComponent)((FluidTankComponent)((Object)new SidedFluidTankComponent("fluid", 16000, 150, 17, 0).setFacingHandlerPos(-15, 46))).setComponentHarness(this);
        this.addTank(this.fluidTank);
        this.inventory.setColor(DyeColor.CYAN);
        this.realOutput.setColor(DyeColor.RED);
        this.fluidInput.setColor(DyeColor.LIGHT_BLUE);
        this.fluidTank.setColor(DyeColor.BLUE);
        this.setShowEnergy(false);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, AssetTestTile blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        this.progressBar.tickBar();
    }

    @Override
    @Nonnull
    public AssetTestTile getSelf() {
        return this;
    }

    @Override
    @ParametersAreNonnullByDefault
    public ItemInteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(player, hand, facing, hitX, hitY, hitZ) == ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION) {
            this.openGui(player);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public IAssetProvider getAssetProvider() {
        return NewAssetProviderTest.TEST_PROVIDER;
    }

    @Override
    @Nonnull
    public EnergyStorageComponent<AssetTestTile> createEnergyStorage() {
        return new EnergyStorageComponent<AssetTestTile>(10000, 0, 0);
    }

    @Override
    public int getTitleColor() {
        return ChatFormatting.RED.getColor();
    }

    @Override
    public float getTitleXPos(float titleWidth, float screenWidth, float screenHeight, float guiWidth, float guiHeight) {
        return super.getTitleXPos(titleWidth, screenWidth, screenHeight, guiWidth, guiHeight) + 30.0f;
    }

    @Override
    public float getTitleYPos(float titleWidth, float screenWidth, float screenHeight, float guiWidth, float guiHeight) {
        return super.getTitleYPos(titleWidth, screenWidth, screenHeight, guiWidth, guiHeight) - 20.0f;
    }
}

