/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.entity.client;

import com.buuz135.industrial.entity.InfinityLauncherProjectileEntity;
import com.buuz135.industrial.entity.client.InfinityLauncherProjectileModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class InfinityLauncherProjectileRenderer
extends EntityRenderer<InfinityLauncherProjectileEntity> {
    public static final ModelLayerLocation PROJECTILE_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"infinity_launcher_projectile"), "main");
    public static final ResourceLocation PROJECTILE = ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"textures/item/infinity_launcher_projectile.png");
    private final InfinityLauncherProjectileModel projectileModel;

    public InfinityLauncherProjectileRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
        this.projectileModel = new InfinityLauncherProjectileModel(p_174008_.bakeLayer(PROJECTILE_LAYER));
    }

    public void render(InfinityLauncherProjectileEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot()) - 90.0f));
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot()) + 90.0f));
        matrixStackIn.translate(0.0, -0.8, 0.0);
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entityIn)));
        this.projectileModel.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, 0xFFFFFF);
        matrixStackIn.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(InfinityLauncherProjectileEntity p_114482_) {
        return PROJECTILE;
    }
}

