/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opoliscompat.kubejs;

import com.benbenlaw.inworldrecipes.recipes.BlockTarget;
import com.benbenlaw.inworldrecipes.recipes.BlockTargetCodec;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockTargetComponent
implements RecipeComponent<BlockTarget> {
    public static final BlockTargetComponent INSTANCE = new BlockTargetComponent();
    public static final RecipeComponentType<?> CONDITION = RecipeComponentType.unit((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"block_target"), (RecipeComponent)INSTANCE);
    private static final Codec<BlockTarget> CODEC = BlockTargetCodec.CODEC;

    public RecipeComponentType<?> type() {
        return CONDITION;
    }

    public Codec<BlockTarget> codec() {
        return CODEC;
    }

    public TypeInfo typeInfo() {
        return TypeInfo.of(BlockTarget.class);
    }

    public BlockTarget wrap(RecipeScriptContext cx, Object from) {
        if (from instanceof BlockTarget) {
            BlockTarget target = (BlockTarget)from;
            return target;
        }
        if (from instanceof String) {
            Block block;
            String s = (String)from;
            if (s.startsWith("#")) {
                String tagId = s.substring(1);
                TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)tagId));
                return new BlockTarget.Tag(tag);
            }
            String blockPart = s;
            String propsPart = null;
            int bracketIndex = s.indexOf(91);
            if (bracketIndex >= 0 && s.endsWith("]")) {
                blockPart = s.substring(0, bracketIndex);
                propsPart = s.substring(bracketIndex + 1, s.length() - 1);
            }
            if ((block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)blockPart))) == Blocks.AIR) {
                throw new RuntimeException("Unknown block: " + blockPart);
            }
            BlockState state = block.defaultBlockState();
            if (propsPart != null) {
                String[] entries;
                for (String entry : entries = propsPart.split(",")) {
                    Comparable val;
                    String[] kv = entry.split("=");
                    if (kv.length != 2) continue;
                    String key = kv[0].trim();
                    String value = kv[1].trim();
                    Property property = block.getStateDefinition().getProperty(key);
                    if (property == null || property == null || (val = (Comparable)property.getValue(value).orElse(null)) == null) continue;
                    Property rawProperty = property;
                    state = (BlockState)state.setValue(rawProperty, val);
                }
            }
            return new BlockTarget.Single(state);
        }
        throw new RuntimeException("Cannot wrap object into BlockTarget: " + String.valueOf(from));
    }

    public boolean matches(RecipeMatchContext cx, BlockTarget value, ReplacementMatchInfo match) {
        return true;
    }
}

