/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opoliscompat.datagen;

import biomesoplenty.api.block.BOPBlocks;
import com.benbenlaw.caveopolis.item.CaveopolisItems;
import com.benbenlaw.cloche.data.recipe.ClocheRecipeProvider;
import com.benbenlaw.colors.block.ColorsBlocks;
import com.benbenlaw.colors.item.ColorsItems;
import com.benbenlaw.core.item.CoreDataComponents;
import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.core.util.ColorList;
import com.benbenlaw.opoliscompat.datagen.cloche.BiomesOPlentyResultsLists;
import com.benbenlaw.opoliscompat.datagen.cloche.CompatResultLists;
import com.benbenlaw.opoliscompat.datagen.cloche.MysticalResources;
import com.benbenlaw.opoliscompat.datagen.cloche.TwilightResultLists;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import twilightforest.block.HugeLilyPadBlock;
import twilightforest.init.TFBlocks;

public class CompatRecipes
extends RecipeProvider {
    public static NonNullList<ChanceResult> createColoredSaplingResults(String color) {
        NonNullList coloredSaplingResults = NonNullList.create();
        coloredSaplingResults.add((Object)new ChanceResult(CompatRecipes.itemWithColor(new ItemStack((ItemLike)CaveopolisItems.COLORED_LOG.get(), 2), color), 1.0f));
        coloredSaplingResults.add((Object)new ChanceResult(CompatRecipes.itemWithColor(new ItemStack((ItemLike)CaveopolisItems.COLORED_SAPLING.get()), color), 0.2f));
        coloredSaplingResults.add((Object)new ChanceResult(CompatRecipes.itemWithColor(new ItemStack((ItemLike)CaveopolisItems.COLORED_APPLE.get()), color), 0.2f));
        coloredSaplingResults.add((Object)new ChanceResult(new ItemStack((ItemLike)Items.STICK), 0.1f));
        return coloredSaplingResults;
    }

    public static NonNullList<ChanceResult> createColoredSaplingResultsColors(String color) {
        NonNullList coloredSaplingResultsColors = NonNullList.create();
        coloredSaplingResultsColors.add((Object)new ChanceResult(new ItemStack((ItemLike)ColorsBlocks.LOGS.get(color + "_log"), 2), 1.0f));
        coloredSaplingResultsColors.add((Object)new ChanceResult(new ItemStack((ItemLike)ColorsBlocks.SAPLINGS.get(color + "_sapling"), 1), 0.2f));
        coloredSaplingResultsColors.add((Object)new ChanceResult(new ItemStack((ItemLike)((DeferredItem)ColorsItems.APPLES.get(color + "_apple")).get(), 1), 0.2f));
        coloredSaplingResultsColors.add((Object)new ChanceResult(new ItemStack((ItemLike)Items.STICK), 0.1f));
        return coloredSaplingResultsColors;
    }

    public CompatRecipes(PackOutput output, CompletableFuture<HolderLookup.Provider> completableFuture) {
        super(output, completableFuture);
    }

    protected void buildRecipes(RecipeOutput consumer) {
        Item seed;
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.ORIGIN_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.ORIGIN_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.ORIGIN_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/origin_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.FLOWERING_OAK_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.FLOWERING_OAK_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.FLOWERING_OAK_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/flowering_oak_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.CYPRESS_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.CYPRESS_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.CYPRESS_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/cypress_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.SNOWBLOSSOM_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.SNOWBLOSSOM_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.SNOWBLOSSOM_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/snowblossom_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.RAINBOW_BIRCH_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.RAINBOW_BIRCH_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.RAINBOW_BIRCH_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/rainbow_birch_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.FIR_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.FIR_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.FIR_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/fir_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.PINE_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.PINE_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.PINE_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/pine_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.RED_MAPLE_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.RED_MAPLE_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.RED_MAPLE_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/red_maple_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.ORANGE_MAPLE_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.ORANGE_MAPLE_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.ORANGE_MAPLE_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/orange_maple_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.YELLOW_MAPLE_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.YELLOW_MAPLE_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.YELLOW_MAPLE_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/yellow_maple_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.MAHOGANY_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.MAHOGANY_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.MAHOGANY_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/mahogany_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.REDWOOD_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.REDWOOD_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.REDWOOD_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/redwood_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.JACARANDA_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.JACARANDA_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.JACARANDA_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/jacaranda_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.PALM_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.PALM_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.PALM_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/palm_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.WILLOW_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.WILLOW_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.WILLOW_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/willow_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.DEAD_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.DEAD_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.DEAD_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/dead_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.MAGIC_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.MAGIC_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.MAGIC_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/magic_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.UMBRAN_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.UMBRAN_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.UMBRAN_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/umbran_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.HELLBARK_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.HELLBARK_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.HELLBARK_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/hellbark_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.EMPYREAL_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, BiomesOPlentyResultsLists.EMPYREAL_SAPLING_RESULTS, (ItemStack)new ItemStack(BOPBlocks.EMPYREAL_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/biomesoplenty/empereal_sapling"));
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.ROSE.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "rose", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.VIOLET.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "lily", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.LAVENDER.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "lavender", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.TALL_LAVENDER.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "tall_lavender", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.WHITE_LAVENDER.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "white_lavender", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.TALL_WHITE_LAVENDER.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "tall_white_lavender", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.BLUE_HYDRANGEA.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "blue_hydrangea", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.GOLDENROD.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "goldenrod", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.ORANGE_COSMOS.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "orange_cosmos", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.PINK_DAFFODIL.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "pink_daffodil", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.PINK_HIBISCUS.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "pink_hibiscus", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.WILDFLOWER.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "wildflower", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.WHITE_PETALS.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "white_petals", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.ICY_IRIS.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "icy_iris", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.GLOWFLOWER.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "glowflower", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.WILTED_LILY.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "wilted_lily", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.BURNING_BLOSSOM.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "burning_blossom", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.ENDBLOOM.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "endbloom", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.SPROUT.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "sprout", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.BUSH.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "bush", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.HIGH_GRASS.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "high_grass", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.CLOVER.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "clover", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.HUGE_CLOVER_PETAL.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "huge_clover_petal", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.WATERLILY.asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET}), 1200, "waterlily", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.DUNE_GRASS.asItem()}), Ingredient.of((TagKey)ItemTags.SAND), 1200, "dune_grass", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.DESERT_GRASS.asItem()}), Ingredient.of((TagKey)ItemTags.SAND), 1200, "desert_grass", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.DEAD_GRASS.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "dead_grass", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.TUNDRA_SHRUB.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "tundra_shrub", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.ENDERPHYTE.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "enderphyte", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.LUMALOOP.asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.END_STONE}), 1200, "lumaloop", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.BARLEY.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "barley", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.SEA_OATS.asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET}), 1200, "sea_oats", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.CATTAIL.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "cattail", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.REED.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "reed", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.WATERGRASS.asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET}), 1200, "watergrass", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.TINY_CACTUS.asItem()}), Ingredient.of((TagKey)ItemTags.SAND), 1200, "tiny_cactus", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.BRAMBLE.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "bramble", consumer);
        this.createSimpleClocheBiomesOPlentyRecipe(Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.BRAMBLE_LEAVES.asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "bramble_leaves", consumer);
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{TFBlocks.TWILIGHT_OAK_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, TwilightResultLists.TWILIGHT_OAK_SAPLING_RESULTS, (ItemStack)new ItemStack(TFBlocks.TWILIGHT_OAK_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("twilightforest")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/twilightforest/twilight_oak_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{TFBlocks.CANOPY_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, TwilightResultLists.CANOPY_SAPLING_RESULTS, (ItemStack)new ItemStack(TFBlocks.CANOPY_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("twilightforest")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/twilightforest/canopy_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{TFBlocks.MANGROVE_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, TwilightResultLists.MANGROVE_SAPLING_RESULTS, (ItemStack)new ItemStack(TFBlocks.MANGROVE_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("twilightforest")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/twilightforest/mangrove_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{TFBlocks.DARKWOOD_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, TwilightResultLists.DARKWOOD_SAPLING_RESULTS, (ItemStack)new ItemStack(TFBlocks.DARK_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("twilightforest")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/twilightforest/darkwood_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{TFBlocks.TIME_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, TwilightResultLists.TIME_SAPLING_RESULTS, (ItemStack)new ItemStack(TFBlocks.TIME_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("twilightforest")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/twilightforest/time_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{TFBlocks.TRANSFORMATION_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, TwilightResultLists.TRANSFORMATION_SAPLING_RESULTS, (ItemStack)new ItemStack(TFBlocks.TRANSFORMATION_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("twilightforest")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/twilightforest/transformation_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{TFBlocks.MINING_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, TwilightResultLists.MINERS_SAPLING_RESULTS, (ItemStack)new ItemStack(TFBlocks.MINING_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("twilightforest")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/twilightforest/mining_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{TFBlocks.SORTING_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, TwilightResultLists.SORTING_SAPLING_RESULTS, (ItemStack)new ItemStack(TFBlocks.SORTING_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("twilightforest")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/twilightforest/sorting_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{TFBlocks.HOLLOW_OAK_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, TwilightResultLists.ROBUST_OAK_SAPLING_RESULTS, (ItemStack)new ItemStack(TFBlocks.TWILIGHT_OAK_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("twilightforest")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/twilightforest/robust_oak_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{TFBlocks.RAINBOW_OAK_SAPLING}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, TwilightResultLists.RAINBOW_OAK_RESULTS, (ItemStack)new ItemStack(TFBlocks.RAINBOW_OAK_LEAVES.asItem().getDefaultInstance().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("twilightforest")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/twilightforest/rainbow_oak_sapling"));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{TFBlocks.TORCHBERRY_PLANT}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, TwilightResultLists.TORCHBERRY_RESULTS, null).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("twilightforest")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)"cloche/twilightforest/torchberry_bush"));
        this.createSimpleClocheTwilightForestRecipe(Ingredient.of((ItemLike[])new ItemLike[]{((Block)TFBlocks.MUSHGLOOM.get()).asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "mushgloom", consumer);
        this.createSimpleClocheTwilightForestRecipe(Ingredient.of((ItemLike[])new ItemLike[]{((Block)TFBlocks.MOSS_PATCH.get()).asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "moss_patch", consumer);
        this.createSimpleClocheTwilightForestRecipe(Ingredient.of((ItemLike[])new ItemLike[]{((Block)TFBlocks.MAYAPPLE.get()).asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "mayapple", consumer);
        this.createSimpleClocheTwilightForestRecipe(Ingredient.of((ItemLike[])new ItemLike[]{((Block)TFBlocks.CLOVER_PATCH.get()).asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "clover_patch", consumer);
        this.createSimpleClocheTwilightForestRecipe(Ingredient.of((ItemLike[])new ItemLike[]{((Block)TFBlocks.FIDDLEHEAD.get()).asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "fiddlehead", consumer);
        this.createSimpleClocheTwilightForestRecipe(Ingredient.of((ItemLike[])new ItemLike[]{((HugeLilyPadBlock)TFBlocks.HUGE_LILY_PAD.get()).asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET}), 1200, "huge_lily_pad", consumer);
        this.createSimpleClocheTwilightForestRecipe(Ingredient.of((ItemLike[])new ItemLike[]{((Block)TFBlocks.HUGE_WATER_LILY.get()).asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET}), 1200, "huge_water_lily", consumer);
        this.createSimpleClocheTwilightForestRecipe(Ingredient.of((ItemLike[])new ItemLike[]{((Block)TFBlocks.THORN_ROSE.get()).asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "thorn_rose", consumer);
        this.createSimpleClocheTwilightForestRecipe(Ingredient.of((ItemLike[])new ItemLike[]{((Block)TFBlocks.GREEN_THORNS.get()).asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "green_thorns", consumer);
        this.createSimpleClocheTwilightForestRecipe(Ingredient.of((ItemLike[])new ItemLike[]{((Block)TFBlocks.BROWN_THORNS.get()).asItem()}), Ingredient.of((TagKey)ItemTags.DIRT), 1200, "brown_thorns", consumer);
        for (String type : MysticalResources.TIER_1_SEEDS) {
            seed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mysticalagriculture", (String)(type + "_seeds")));
            ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{seed}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{CompatResultLists.INFERIUM_FARMLAND}), null, null, (int)2400, CompatResultLists.RESULTS_LIST_BY_TYPE.get(type), null).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("mysticalagriculture")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)("cloche/mysticalagriculture/" + type + "_seed")));
        }
        for (String type : MysticalResources.TIER_2_SEEDS) {
            seed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mysticalagriculture", (String)(type + "_seeds")));
            ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{seed}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{CompatResultLists.PRUDENTIUM_FARMLAND}), null, null, (int)2400, CompatResultLists.RESULTS_LIST_BY_TYPE.get(type), null).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("mysticalagriculture")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)("cloche/mysticalagriculture/" + type + "_seed")));
        }
        for (String type : MysticalResources.TIER_3_SEEDS) {
            seed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mysticalagriculture", (String)(type + "_seeds")));
            ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{seed}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{CompatResultLists.TERTIUM_FARMLAND}), null, null, (int)2400, CompatResultLists.RESULTS_LIST_BY_TYPE.get(type), null).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("mysticalagriculture")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)("cloche/mysticalagriculture/" + type + "_seed")));
        }
        for (String type : MysticalResources.TIER_4_SEEDS) {
            seed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mysticalagriculture", (String)(type + "_seeds")));
            ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{seed}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{CompatResultLists.IMPERIUM_FARMLAND}), null, null, (int)2400, CompatResultLists.RESULTS_LIST_BY_TYPE.get(type), null).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("mysticalagriculture")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)("cloche/mysticalagriculture/" + type + "_seed")));
        }
        for (String type : MysticalResources.TIER_5_SEEDS) {
            seed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mysticalagriculture", (String)(type + "_seeds")));
            ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{seed}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{CompatResultLists.SUPREMIUM_FARMLAND}), null, null, (int)2400, CompatResultLists.RESULTS_LIST_BY_TYPE.get(type), null).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("mysticalagriculture")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)("cloche/mysticalagriculture/" + type + "_seed")));
        }
        for (String type : MysticalResources.TIER_6_SEEDS) {
            seed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mysticalagriculture", (String)(type + "_seeds")));
            Item crux = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"mysticalagradditions", (String)(type + "_crux")));
            ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{seed}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{CompatResultLists.INSANIUM_FARMLAND}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{crux}), null, (int)3000, CompatResultLists.RESULTS_LIST_BY_TYPE.get(type), null).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("mysticalagradditions")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)("cloche/mysticalagriculture/" + type + "_seed")));
        }
        for (String color : ColorList.COLORS) {
            NonNullList<ChanceResult> resultsWithColor = CompatRecipes.createColoredSaplingResults(color);
            this.createClocheRecipe(consumer, color, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)CaveopolisItems.COLORED_SAPLING.get()}), Ingredient.of((TagKey)ItemTags.DIRT), null, null, 1200, resultsWithColor, CompatRecipes.itemWithColor(((Item)CaveopolisItems.COLORED_LEAVES.get()).getDefaultInstance(), color));
            this.createSimpleClocheRecipe(((Item)CaveopolisItems.COLORED_POPPY.get()).getDefaultInstance(), Ingredient.of((TagKey)ItemTags.DIRT), 1200, color, "_poppy", consumer);
            this.createSimpleClocheRecipe(((Item)CaveopolisItems.COLORED_DANDELION.get()).getDefaultInstance(), Ingredient.of((TagKey)ItemTags.DIRT), 1200, color, "_dandelion", consumer);
            NonNullList<ChanceResult> resultsColors = CompatRecipes.createColoredSaplingResultsColors(color);
            ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ColorsBlocks.SAPLINGS.get(color + "_sapling")}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, resultsColors, (ItemStack)new ItemStack(((DeferredBlock)ColorsBlocks.LEAVES.get(color + "_leaves")).toStack().getItemHolder(), 2)).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("colors")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)("cloche/colors/" + color + "_sapling")));
            NonNullList poppy = NonNullList.create();
            poppy.add((Object)new ChanceResult(new ItemStack((ItemLike)ColorsBlocks.POPPY.get(color + "_poppy")), 1.0f));
            ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ColorsBlocks.POPPY.get(color + "_poppy")}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, (NonNullList)poppy, null).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("colors")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)("cloche/colors/" + color + "_poppy")));
            NonNullList dandelion = NonNullList.create();
            dandelion.add((Object)new ChanceResult(new ItemStack((ItemLike)ColorsBlocks.DANDELION.get(color + "_dandelion")), 1.0f));
            ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ColorsBlocks.DANDELION.get(color + "_dandelion")}), (Ingredient)Ingredient.of((TagKey)ItemTags.DIRT), null, null, (int)1200, (NonNullList)dandelion, null).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("colors")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)("cloche/colors/" + color + "_dandelion")));
        }
    }

    private void createClocheRecipe(RecipeOutput consumer, String color, Ingredient seed, Ingredient soil, Ingredient catalyst, String dimension, int duration, NonNullList<ChanceResult> results, ItemStack shearsResult) {
        Ingredient saplingColor = DataComponentIngredient.of((boolean)false, (DataComponentPredicate)DataComponentPredicate.builder().expect((DataComponentType)CoreDataComponents.COLOR.get(), (Object)color).build(), (ItemLike[])new ItemLike[]{CompatRecipes.itemWithColor(new ItemStack((ItemLike)seed.getItems()[0].getItem()), color).getItem()});
        ItemStack shearsResultColor = CompatRecipes.itemWithColor(shearsResult, color);
        shearsResultColor.setCount(2);
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)saplingColor, (Ingredient)soil, (Ingredient)catalyst, (String)dimension, (int)duration, results, (ItemStack)shearsResultColor).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("caveopolis")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)("cloche/caveopolis/" + color + "_sapling")));
    }

    private void createSimpleClocheRecipe(ItemStack seed, Ingredient soil, int duration, String color, String name, RecipeOutput consumer) {
        Ingredient flowerColor = DataComponentIngredient.of((boolean)false, (DataComponentPredicate)DataComponentPredicate.builder().expect((DataComponentType)CoreDataComponents.COLOR.get(), (Object)color).build(), (ItemLike[])new ItemLike[]{CompatRecipes.itemWithColor(new ItemStack((ItemLike)seed.getItem()), color).getItem()});
        NonNullList SINGLE_ITEM_RESULTS = NonNullList.create();
        SINGLE_ITEM_RESULTS.add((Object)new ChanceResult(CompatRecipes.itemWithColor(new ItemStack((ItemLike)seed.getItem()), color), 1.0f));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)flowerColor, (Ingredient)soil, null, null, (int)duration, (NonNullList)SINGLE_ITEM_RESULTS, null).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("caveopolis")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)("cloche/caveopolis/" + color + name)));
    }

    private void createSimpleClocheTwilightForestRecipe(Ingredient seed, Ingredient soil, int duration, String name, RecipeOutput consumer) {
        NonNullList SINGLE_ITEM_RESULTS = NonNullList.create();
        SINGLE_ITEM_RESULTS.add((Object)new ChanceResult(new ItemStack((ItemLike)seed.getItems()[0].getItem(), 1), 1.0f));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)seed, (Ingredient)soil, null, null, (int)duration, (NonNullList)SINGLE_ITEM_RESULTS, null).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("twilightforest")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)("cloche/twilightforest/" + name)));
    }

    private void createSimpleClocheBiomesOPlentyRecipe(Ingredient seed, Ingredient soil, int duration, String name, RecipeOutput consumer) {
        NonNullList SINGLE_ITEM_RESULTS = NonNullList.create();
        SINGLE_ITEM_RESULTS.add((Object)new ChanceResult(new ItemStack((ItemLike)seed.getItems()[0].getItem(), 1), 1.0f));
        ClocheRecipeProvider.ClocheRecipeBuilder((Ingredient)seed, (Ingredient)soil, null, null, (int)duration, (NonNullList)SINGLE_ITEM_RESULTS, null).save(consumer.withConditions(new ICondition[]{new ModLoadedCondition("biomesoplenty")}).withConditions(new ICondition[]{new ModLoadedCondition("cloche")}), ResourceLocation.fromNamespaceAndPath((String)"bblcompat", (String)("cloche/biomesoplenty/" + name)));
    }

    private static ItemStack itemWithColor(ItemStack item, String color) {
        item.set((Supplier)CoreDataComponents.COLOR, (Object)color);
        item.set((Supplier)CoreDataComponents.LIT, (Object)false);
        return item;
    }
}

