/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.processor.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public record MethodReference(ExecutableElement methodElement) {
    public TypeMirror enclosingClass() {
        return this.methodElement.getEnclosingElement().asType();
    }

    public String getName() {
        return this.methodElement.getSimpleName().toString();
    }

    private Set<Modifier> modifiers() {
        return this.methodElement.getModifiers();
    }

    public boolean isPublic() {
        return this.modifiers().contains((Object)Modifier.PUBLIC);
    }

    public boolean isStatic() {
        return this.modifiers().contains((Object)Modifier.STATIC);
    }

    public TypeMirror returnType() {
        return this.methodElement.getReturnType();
    }

    public List<TypeMirror> parameterTypes() {
        List<? extends VariableElement> parameters = this.methodElement.getParameters();
        ArrayList<TypeMirror> parameterTypes = new ArrayList<TypeMirror>(parameters.size());
        for (VariableElement variableElement : parameters) {
            parameterTypes.add(variableElement.asType());
        }
        return parameterTypes;
    }
}

