/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.io.typed;

import com.bawnorton.configurable.util.GenericType;
import io.netty.buffer.ByteBuf;

public class TypedWriter<T> {
    private ByteBufWriter<T> byteBufWriter;

    public static <T> TypedWriter<T> create() {
        return new TypedWriter<T>();
    }

    public TypedWriter<T> byteBuf(ByteBufWriter<T> writer) {
        this.byteBufWriter = writer;
        return this;
    }

    void writeByteBuf(ByteBuf buf, T item, GenericType expectedType) {
        if (this.byteBufWriter == null) {
            throw new UnsupportedOperationException("ByteBuf writing not supported for this type");
        }
        this.byteBufWriter.write(buf, item, expectedType);
    }

    public static interface ByteBufWriter<T> {
        public static <T> Contextless<T> contextless(Contextless<T> writer) {
            return writer;
        }

        public void write(ByteBuf var1, T var2, GenericType var3);

        public static interface Contextless<T>
        extends ByteBufWriter<T> {
            public void write(ByteBuf var1, T var2);

            @Override
            default public void write(ByteBuf buf, T item, GenericType expectedType) {
                this.write(buf, item);
            }
        }
    }
}

