/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.RecipeTypeFunction;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.schema.KubeRecipeFactory;
import dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor;
import dev.latvian.mods.kubejs.recipe.schema.RecipeOptional;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaStorage;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.recipe.schema.function.AddToListFunction;
import dev.latvian.mods.kubejs.recipe.schema.function.RecipeFunctionInstance;
import dev.latvian.mods.kubejs.recipe.schema.function.SetFunction;
import dev.latvian.mods.kubejs.recipe.schema.postprocessing.RecipePostProcessor;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.rhino.util.RemapForJS;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RecipeSchema {
    public KubeRecipeFactory recipeFactory = KubeRecipeFactory.DEFAULT;
    public ResourceLocation typeOverride = null;
    public final List<RecipeKey<?>> keys;
    public final List<RecipeKey<?>> includedKeys;
    public final Map<RecipeKey<?>, RecipeOptional<?>> keyOverrides;
    public final Map<String, RecipeFunctionInstance> functions;
    private int inputCount;
    private int outputCount;
    private int minRequiredArguments;
    private Int2ObjectMap<RecipeConstructor> constructors;
    private boolean constructorsGenerated;
    private List<RecipeKey<?>> uniqueIds;
    boolean hidden;
    private List<RecipePostProcessor> postProcessors;

    public RecipeSchema(Map<RecipeKey<?>, RecipeOptional<?>> keyOverrides, List<RecipeKey<?>> keys) {
        this.keys = List.copyOf(keys);
        this.keyOverrides = Map.copyOf(keyOverrides);
        this.includedKeys = List.copyOf(this.keys.stream().filter(k -> (k.optional == null || !k.excluded) && !this.keyOverrides.containsKey(k)).toList());
        this.functions = new LinkedHashMap<String, RecipeFunctionInstance>(0);
        this.minRequiredArguments = 0;
        this.inputCount = 0;
        this.outputCount = 0;
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this.includedKeys.size(); ++i) {
            RecipeKey<?> k2 = this.includedKeys.get(i);
            if (k2.optional()) {
                if (this.minRequiredArguments == 0) {
                    this.minRequiredArguments = i;
                }
            } else if (this.minRequiredArguments > 0) {
                throw new IllegalArgumentException("Required key '" + k2.name + "' must be ahead of optional keys!");
            }
            if (!set.add(k2.name)) {
                throw new IllegalArgumentException("Duplicate key '" + k2.name + "' found!");
            }
            if (k2.role.isInput()) {
                ++this.inputCount;
            } else if (k2.role.isOutput()) {
                ++this.outputCount;
            }
            if (!k2.alwaysWrite || !k2.optional() || !k2.optional.isDefault()) continue;
            throw new IllegalArgumentException("Key '" + String.valueOf(k2) + "' can't have alwaysWrite() enabled with defaultOptional()!");
        }
        if (this.minRequiredArguments == 0) {
            this.minRequiredArguments = this.includedKeys.size();
        }
        this.uniqueIds = List.of();
        this.hidden = false;
    }

    public RecipeSchema(RecipeKey<?> ... keys) {
        this(Map.of(), List.of(keys));
    }

    public RecipeSchema factory(KubeRecipeFactory factory) {
        this.recipeFactory = factory;
        return this;
    }

    public RecipeSchema typeOverride(ResourceLocation id) {
        this.typeOverride = id;
        return this;
    }

    public RecipeSchema constructor(RecipeConstructor constructor) {
        if (this.constructors == null) {
            this.constructors = new Int2ObjectArrayMap(this.keys.size() - this.minRequiredArguments() + 1);
        }
        if (this.constructors.put(constructor.keys.size(), (Object)constructor) != null) {
            throw new IllegalStateException("Constructor with " + constructor.keys.size() + " arguments already exists!");
        }
        return this;
    }

    @RemapForJS(value="addConstructor")
    public RecipeSchema constructor(RecipeKey<?> ... keys) {
        return this.constructor(new RecipeConstructor(keys));
    }

    public RecipeSchema uniqueId(RecipeKey<?> key) {
        this.uniqueIds = List.of(key);
        return this;
    }

    public RecipeSchema uniqueIds(SequencedCollection<RecipeKey<?>> keys) {
        this.uniqueIds = List.copyOf(keys);
        return this;
    }

    @Nullable
    public String buildUniqueId(KubeRecipe r) {
        if (this.uniqueIds.isEmpty()) {
            return null;
        }
        if (this.uniqueIds.size() == 1) {
            RecipeKey<?> key = this.uniqueIds.getFirst();
            Object value = r.getValue(key);
            if (value != null) {
                UniqueIdBuilder builder = new UniqueIdBuilder(new StringBuilder());
                key.component.buildUniqueId(builder, Cast.to(value));
                return builder.build();
            }
            return null;
        }
        StringBuilder sb = new StringBuilder();
        UniqueIdBuilder builder = new UniqueIdBuilder(new StringBuilder());
        boolean first = true;
        for (RecipeKey<?> key : this.keys) {
            Object value = r.getValue(key);
            if (value == null) continue;
            key.component.buildUniqueId(builder, Cast.to(value));
            String result = builder.build();
            if (result == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append('/');
            }
            sb.append(result);
        }
        return sb.isEmpty() ? null : sb.toString();
    }

    public Int2ObjectMap<RecipeConstructor> constructors() {
        if (this.constructors == null) {
            this.constructorsGenerated = true;
            this.constructors = this.includedKeys.isEmpty() ? new Int2ObjectArrayMap() : new Int2ObjectArrayMap(this.includedKeys.size() - this.minRequiredArguments + 1);
            boolean dev = DevProperties.get().logRecipeDebug;
            if (dev) {
                KubeJS.LOGGER.info("Generating constructors for {}", (Object)new RecipeConstructor(this.includedKeys));
            }
            for (int a = this.minRequiredArguments; a <= this.includedKeys.size(); ++a) {
                RecipeConstructor c = new RecipeConstructor(List.copyOf(this.includedKeys.subList(0, a)));
                this.constructors.put(a, (Object)c);
                if (!dev) continue;
                KubeJS.LOGGER.info("> {}: {}", (Object)a, (Object)c);
            }
        }
        return this.constructors;
    }

    public List<RecipeKey<?>> uniqueIds() {
        return this.uniqueIds;
    }

    public int minRequiredArguments() {
        return this.minRequiredArguments;
    }

    public int inputCount() {
        return this.inputCount;
    }

    public int outputCount() {
        return this.outputCount;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean constructorsGenerated() {
        this.constructors();
        return this.constructorsGenerated;
    }

    public KubeRecipe deserialize(SourceLine sourceLine, RecipeTypeFunction type, @Nullable ResourceLocation id, JsonObject json) {
        KubeRecipe r = this.recipeFactory.create(type, sourceLine, id == null);
        r.id = id;
        r.json = json;
        r.newRecipe = id == null;
        r.originalJson = json == null || id == null ? null : (JsonObject)JsonUtils.copy((JsonElement)json);
        r.deserialize(false);
        return r;
    }

    public RecipeSchema function(RecipeFunctionInstance function) {
        this.functions.put(function.name(), function);
        return this;
    }

    public <T> RecipeSchema setOpFunction(String name, RecipeKey<T> key, T value) {
        return this.function(new RecipeFunctionInstance(name, new SetFunction.Resolved<T>(key, value)));
    }

    public <T> RecipeSchema addToListOpFunction(String name, RecipeKey<List<T>> key) {
        return this.function(new RecipeFunctionInstance(name, new AddToListFunction.Resolved<T>(key)));
    }

    public RecipeSchema postProcessor(RecipePostProcessor processor) {
        if (this.postProcessors == null) {
            this.postProcessors = new ArrayList<RecipePostProcessor>(1);
        }
        this.postProcessors.add(processor);
        return this;
    }

    @Nullable
    public <T> RecipeKey<T> getOptionalKey(String id) {
        for (RecipeKey<?> key : this.keys) {
            if (!key.name.equals(id)) continue;
            return key;
        }
        return null;
    }

    public <T> RecipeKey<T> getKey(String id) {
        RecipeKey<T> key = this.getOptionalKey(id);
        if (key != null) {
            return key;
        }
        throw new NullPointerException("Key '" + id + "' not found");
    }

    public List<RecipePostProcessor> postProcessors() {
        return this.postProcessors == null ? List.of() : this.postProcessors;
    }

    public JsonObject toJson(RecipeSchemaStorage storage, RecipeSchemaType schemaType, RegistryOps<JsonElement> ops) {
        JsonArray a;
        JsonObject json = new JsonObject();
        if (this.keys != null && !this.keys.isEmpty()) {
            a = new JsonArray();
            for (RecipeKey recipeKey : this.keys) {
                a.add((JsonElement)recipeKey.toJson(storage, schemaType, (DynamicOps<JsonElement>)ops));
            }
            json.add("keys", (JsonElement)a);
        }
        if (!this.uniqueIds.isEmpty()) {
            a = new JsonArray();
            for (RecipeKey recipeKey : this.uniqueIds) {
                a.add(recipeKey.name);
            }
            if (!a.isEmpty()) {
                json.add("unique", (JsonElement)a);
            }
        }
        if (!this.constructorsGenerated()) {
            a = new JsonArray();
            for (RecipeConstructor recipeConstructor : this.constructors().values()) {
                a.add((JsonElement)recipeConstructor.toJson(schemaType, (DynamicOps<JsonElement>)ops));
            }
            if (!a.isEmpty()) {
                json.add("constructors", (JsonElement)a);
            }
        }
        if (this.postProcessors != null && !this.postProcessors.isEmpty()) {
            a = new JsonArray();
            for (RecipePostProcessor recipePostProcessor : this.postProcessors) {
                a.add((JsonElement)storage.recipePostProcessorCodec.encodeStart(ops, (Object)recipePostProcessor).getOrThrow());
            }
            json.add("post_processors", (JsonElement)a);
        }
        return json;
    }
}

