/*
 * Decompiled with CFR 0.152.
 */
package fuzs.resourcepackoverrides.client.handler;

import com.mojang.blaze3d.platform.Window;
import fuzs.resourcepackoverrides.client.data.ResourceOverridesManager;
import fuzs.resourcepackoverrides.services.ClientAbstractions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.packs.TransferableSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class PackActionsHandler {
    private static final Int2ObjectMap<PackAction> PACK_ACTIONS = new Int2ObjectOpenHashMap();
    private static boolean debugTooltips;

    public static void onScreen$Render$Post(Minecraft minecraft, PackSelectionScreen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (debugTooltips && screen.model.repository == minecraft.getResourcePackRepository()) {
            PackActionsHandler.getHoveredPackId(screen, mouseX, mouseY).map(Component::literal).ifPresent(component -> guiGraphics.renderTooltip(ClientAbstractions.INSTANCE.getScreenFont((Screen)screen), (Component)component, mouseX, mouseY));
        }
    }

    private static Optional<String> getHoveredPackId(PackSelectionScreen screen, int mouseX, int mouseY) {
        if (screen == null) {
            return Optional.empty();
        }
        for (GuiEventListener guiEventListener : screen.children()) {
            if (!(guiEventListener instanceof TransferableSelectionList)) continue;
            TransferableSelectionList selectionList = (TransferableSelectionList)guiEventListener;
            TransferableSelectionList.PackEntry hovered = null;
            for (TransferableSelectionList.PackEntry packEntry : selectionList.children()) {
                if (!packEntry.isMouseOver((double)mouseX, (double)mouseY)) continue;
                hovered = packEntry;
                break;
            }
            if (hovered == null) continue;
            return Optional.of(hovered.getPackId().replace("\u00a7", "\\u00A7"));
        }
        return Optional.empty();
    }

    public static void onClientTick$End(Minecraft minecraft) {
        PACK_ACTIONS.values().forEach(action -> action.tick(minecraft));
    }

    public static void onKeyPressed$Post(Minecraft minecraft, PackSelectionScreen screen, int keyCode, int scanCode, int modifiers) {
        PackAction packAction;
        if (screen.model.repository == minecraft.getResourcePackRepository() && (packAction = (PackAction)PACK_ACTIONS.get(keyCode)) != null) {
            packAction.update();
        }
    }

    static {
        PACK_ACTIONS.put(67, (Object)new PackAction((Component)Component.translatable((String)"packAction.copyId.title"), (Component)Component.translatable((String)"packAction.copyId.description", (Object[])new Object[]{Component.literal((String)"C").withStyle(ChatFormatting.BOLD)}), (Component)Component.translatable((String)"packAction.copyId.success")){

            @Override
            boolean execute(Minecraft minecraft, PackSelectionScreen screen) {
                MouseHandler mouseHandler = minecraft.mouseHandler;
                Window window = minecraft.getWindow();
                int mouseX = (int)(mouseHandler.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth());
                int mouseY = (int)(mouseHandler.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight());
                Optional<String> hoveredPackId = PackActionsHandler.getHoveredPackId(screen, mouseX, mouseY);
                hoveredPackId.ifPresent(arg_0 -> ((KeyboardHandler)minecraft.keyboardHandler).setClipboard(arg_0));
                return hoveredPackId.isPresent();
            }
        });
        PACK_ACTIONS.put(68, (Object)new PackAction((Component)Component.translatable((String)"packAction.toggleDebug.title"), (Component)Component.translatable((String)"packAction.toggleDebug.description", (Object[])new Object[]{Component.literal((String)"D").withStyle(ChatFormatting.BOLD)}), (Component)Component.translatable((String)"packAction.toggleDebug.success")){

            @Override
            boolean execute(Minecraft minecraft, PackSelectionScreen screen) {
                debugTooltips = !debugTooltips;
                return true;
            }
        });
        PACK_ACTIONS.put(82, (Object)new PackAction((Component)Component.translatable((String)"packAction.reloadSettings.title"), (Component)Component.translatable((String)"packAction.reloadSettings.description", (Object[])new Object[]{Component.literal((String)"R").withStyle(ChatFormatting.BOLD)}), (Component)Component.translatable((String)"packAction.reloadSettings.success")){

            @Override
            boolean execute(Minecraft minecraft, PackSelectionScreen screen) {
                ResourceOverridesManager.load();
                screen.init(minecraft, minecraft.getWindow().getGuiScaledWidth(), minecraft.getWindow().getGuiScaledHeight());
                return true;
            }
        });
        PACK_ACTIONS.put(84, (Object)new PackAction((Component)Component.translatable((String)"packAction.restoreDefaults.title"), (Component)Component.translatable((String)"packAction.restoreDefaults.description", (Object[])new Object[]{Component.literal((String)"T").withStyle(ChatFormatting.BOLD)}), (Component)Component.translatable((String)"packAction.restoreDefaults.success")){

            @Override
            boolean execute(Minecraft minecraft, PackSelectionScreen screen) {
                minecraft.getResourcePackRepository().setSelected(ResourceOverridesManager.getDefaultResourcePacks(true));
                screen.model.selected.clear();
                screen.model.selected.addAll(minecraft.getResourcePackRepository().getSelectedPacks());
                Collections.reverse(screen.model.selected);
                screen.init(minecraft, minecraft.getWindow().getGuiScaledWidth(), minecraft.getWindow().getGuiScaledHeight());
                return true;
            }
        });
    }

    private static abstract class PackAction {
        private final Component title;
        private final Component description;
        private final Component success;
        @Nullable
        private TutorialToast toast;
        @Nullable
        private TutorialToast successToast;
        private int successTicks;
        private int pressTime;
        private int lastPressTime;
        private int decreaseTimeDelay;
        private boolean wasExecuted;

        public PackAction(Component title, Component description, Component success) {
            this.title = title;
            this.description = description;
            this.success = success;
        }

        public void tick(Minecraft minecraft) {
            if (this.pressTime == this.lastPressTime && this.pressTime > 0 && --this.decreaseTimeDelay < 0) {
                if (this.wasExecuted) {
                    this.reset();
                } else {
                    --this.pressTime;
                }
            }
            this.lastPressTime = this.pressTime;
            if (this.pressTime > 0) {
                Screen screen;
                if (this.toast == null) {
                    this.toast = new TutorialToast(TutorialToast.Icons.MOVEMENT_KEYS, this.title, this.description, true);
                    minecraft.getToasts().addToast((Toast)this.toast);
                }
                if (this.pressTime < 20) {
                    this.toast.updateProgress(Mth.clamp((float)((float)this.pressTime / 20.0f), (float)0.0f, (float)1.0f));
                } else if (!this.wasExecuted && (screen = minecraft.screen) instanceof PackSelectionScreen) {
                    PackSelectionScreen screen2 = (PackSelectionScreen)screen;
                    if (screen2.model.repository == minecraft.getResourcePackRepository()) {
                        if (this.execute(minecraft, screen2)) {
                            this.finish(minecraft);
                        }
                        this.wasExecuted = true;
                        this.toast.updateProgress(1.0f);
                    }
                }
            } else {
                this.reset();
            }
            if (this.successTicks > 0) {
                --this.successTicks;
                this.successToast.updateProgress((float)this.successTicks / 80.0f);
            } else if (this.successToast != null) {
                this.successToast.hide();
                this.successToast = null;
            }
        }

        private void reset() {
            if (this.toast != null) {
                this.toast.hide();
                this.toast = null;
            }
            this.lastPressTime = 0;
            this.pressTime = 0;
            this.wasExecuted = false;
        }

        abstract boolean execute(Minecraft var1, PackSelectionScreen var2);

        private void finish(Minecraft minecraft) {
            if (this.successToast != null) {
                this.successToast.hide();
            }
            this.successToast = new TutorialToast(TutorialToast.Icons.MOVEMENT_KEYS, this.title, this.success, true);
            minecraft.getToasts().addToast((Toast)this.successToast);
            this.successTicks = 80;
            this.successToast.updateProgress(1.0f);
        }

        public void update() {
            ++this.pressTime;
            this.resetDelay();
        }

        public void resetDelay() {
            this.decreaseTimeDelay = 10;
        }
    }
}

