/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.nojang.world.entity.player;

import com.hypherionmc.craterlib.nojang.authlib.BridgedGameProfile;
import com.hypherionmc.craterlib.nojang.core.BridgedBlockPos;
import com.hypherionmc.craterlib.nojang.world.level.BridgedGameType;
import com.hypherionmc.craterlib.utils.ChatUtils;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import shadow.kyori.adventure.text.Component;

public class BridgedPlayer {
    private final Player internal;

    public Component getDisplayName() {
        return ChatUtils.mojangToAdventure(this.internal.getDisplayName());
    }

    public Component getName() {
        return ChatUtils.mojangToAdventure(this.internal.getName());
    }

    public UUID getUUID() {
        return this.internal.getUUID();
    }

    public String getStringUUID() {
        return this.internal.getStringUUID();
    }

    public BridgedGameProfile getGameProfile() {
        return BridgedGameProfile.of(this.internal.getGameProfile());
    }

    public boolean isServerPlayer() {
        return this.internal instanceof ServerPlayer;
    }

    public Player toMojang() {
        return this.internal;
    }

    public BridgedBlockPos getOnPos() {
        return BridgedBlockPos.of(this.internal.getOnPos());
    }

    public float getHealth() {
        return this.internal.getHealth();
    }

    public float getMaxHealth() {
        return this.internal.getMaxHealth();
    }

    public String getHeldItemMainHand() {
        String value = "Nothing";
        if (!this.internal.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            value = this.internal.getItemInHand(InteractionHand.MAIN_HAND).getDisplayName().getString();
        }
        return value;
    }

    public String getHeldItemOffHand() {
        String value = "Nothing";
        if (!this.internal.getItemInHand(InteractionHand.OFF_HAND).isEmpty()) {
            value = this.internal.getItemInHand(InteractionHand.OFF_HAND).getDisplayName().getString();
        }
        return value;
    }

    public BridgedGameType getGameMode() {
        return BridgedGameType.fromMojang(this.toMojangServerPlayer().gameMode.getGameModeForPlayer());
    }

    @Nullable
    public ServerGamePacketListenerImpl getConnection() {
        if (this.isServerPlayer()) {
            return ((ServerPlayer)this.internal).connection;
        }
        return null;
    }

    public void disconnect(Component message) {
        if (this.isServerPlayer()) {
            this.toMojangServerPlayer().connection.disconnect(ChatUtils.adventureToMojang(message));
        }
    }

    public ServerPlayer toMojangServerPlayer() {
        return (ServerPlayer)this.internal;
    }

    private BridgedPlayer(Player internal) {
        this.internal = internal;
    }

    public static BridgedPlayer of(Player internal) {
        return new BridgedPlayer(internal);
    }
}

