/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.cloche.screen;

import com.benbenlaw.cloche.block.ClocheBlock;
import com.benbenlaw.cloche.networking.OnOffButtonPayload;
import com.benbenlaw.cloche.screen.ClocheMenu;
import com.benbenlaw.core.screen.util.CoreButtons;
import com.benbenlaw.core.screen.util.TooltipArea;
import com.benbenlaw.core.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClocheScreen
extends AbstractContainerScreen<ClocheMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cloche", (String)"textures/gui/cloche.png");
    int x;
    int y;

    public ClocheScreen(ClocheMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.x = (this.width - this.imageWidth) / 2;
        this.y = (this.height - this.imageHeight) / 2;
        this.imageHeight = 165;
        this.imageWidth = 175;
    }

    protected void init() {
        super.init();
        this.addMenuButtons();
    }

    protected void containerTick() {
        this.clearWidgets();
        this.addMenuButtons();
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (!((ClocheMenu)this.menu).blockEntity.errorMessage.isEmpty()) {
            guiGraphics.blit(TEXTURE, x + 21, y - 17, 177, 17, 20, 18);
            this.renderErrorTooltip(guiGraphics, mouseX, mouseY, x, y);
        }
        if (((ClocheMenu)this.menu).blockEntity.errorMessage.isEmpty()) {
            guiGraphics.blit(TEXTURE, x + 21, y - 17, 177, 35, 20, 18);
            this.renderTickRate(guiGraphics, mouseX, mouseY, x, y);
        }
        if (((ClocheMenu)this.menu).isCrafting()) {
            guiGraphics.blit(TEXTURE, x + 49, y + 25, 176, 0, ((ClocheMenu)this.menu).getScaledProgress(), 16);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderSlotTooltips(guiGraphics, mouseX, mouseY, x, y);
    }

    private void renderSlotTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        ArrayList<TooltipArea> tooltipAreas = new ArrayList<TooltipArea>();
        tooltipAreas.add(new TooltipArea(8, 17, 16, 16, "block.cloche.gui.seed_slot"));
        tooltipAreas.add(new TooltipArea(8, 35, 16, 16, "block.cloche.gui.soil_slot"));
        tooltipAreas.add(new TooltipArea(35, 53, 16, 16, "block.cloche.gui.upgrade_slot"));
        tooltipAreas.add(new TooltipArea(53, 53, 16, 16, "block.cloche.gui.upgrade_slot"));
        tooltipAreas.add(new TooltipArea(71, 53, 16, 16, "block.cloche.gui.upgrade_slot"));
        if (((ClocheMenu)this.menu).numberOfCatalysts == 0) {
            tooltipAreas.add(new TooltipArea(8, 53, 16, 16, "block.cloche.gui.catalyst_slot_no_catalysts"));
        } else {
            tooltipAreas.add(new TooltipArea(8, 53, 16, 16, "block.cloche.gui.catalyst_slot"));
        }
        for (TooltipArea area : tooltipAreas) {
            if (!MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)area.offsetX, (int)area.offsetY, (int)area.width, (int)area.height) || !((ClocheMenu)this.menu).getCarried().isEmpty() || this.hoveredSlot == null || this.hoveredSlot.hasItem()) continue;
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)area.translationKey), mouseX, mouseY);
        }
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)0, (int)-17, (int)19, (int)18)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"block.cloche.gui.on_off"), mouseX, mouseY);
        }
    }

    @Nullable
    private void renderTickRate(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)20, (int)-17, (int)19, (int)18)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)(((ClocheMenu)this.menu).getProgress() + "/" + ((ClocheMenu)this.menu).getMaxProgress())), mouseX, mouseY);
        }
    }

    private void renderErrorTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)20, (int)-17, (int)19, (int)18)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)((ClocheMenu)this.menu).blockEntity.errorMessage), mouseX, mouseY);
        }
    }

    private void addMenuButtons() {
        int buttonX = this.leftPos;
        int buttonY = this.topPos - 17;
        if (((ClocheMenu)this.menu).blockEntity != null) {
            WidgetSprites buttonTexture = (Boolean)((ClocheMenu)this.menu).blockEntity.getBlockState().getValue((Property)ClocheBlock.POWERED) != false ? CoreButtons.ON_BUTTONS : CoreButtons.OFF_BUTTONS;
            this.addRenderableWidget((GuiEventListener)new ImageButton(buttonX, buttonY, 20, 18, buttonTexture, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new OnOffButtonPayload(((ClocheMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])));
        }
    }
}

