/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.cloche.recipe;

import com.benbenlaw.core.recipe.ChanceResult;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ClocheRecipe(Ingredient seed, Ingredient soil, Ingredient catalyst, String dimension, int duration, NonNullList<ChanceResult> results, ItemStack shearsResult) implements Recipe<RecipeInput>
{
    public boolean matches(RecipeInput container, @NotNull Level level) {
        boolean needCatalyst;
        boolean bl = needCatalyst = !this.catalyst.isEmpty();
        if (needCatalyst) {
            if (this.catalyst.test(container.getItem(2))) {
                return this.seed.test(container.getItem(0)) && this.soil.test(container.getItem(1));
            }
            return false;
        }
        return this.seed.test(container.getItem(0)) && this.soil.test(container.getItem(1));
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ((ChanceResult)this.results.getFirst()).stack().copy();
    }

    public boolean canCraftInDimensions(int x, int y) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ((ChanceResult)this.results.getFirst()).stack();
    }

    public List<ItemStack> getResults() {
        return this.getRollResults().stream().map(ChanceResult::stack).collect(Collectors.toList());
    }

    public NonNullList<ChanceResult> getRollResults() {
        return this.results;
    }

    public List<ItemStack> rollResults(RandomSource rand) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        NonNullList<ChanceResult> rollResults = this.getRollResults();
        for (ChanceResult output : rollResults) {
            ItemStack stack = output.rollOutput(rand);
            if (stack.isEmpty()) continue;
            results.add(stack);
        }
        return results;
    }

    public Ingredient getSeed() {
        return this.seed;
    }

    public Ingredient getSoil() {
        return this.soil;
    }

    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public String getDimension() {
        return this.dimension;
    }

    public ItemStack getShearsResult() {
        return this.shearsResult;
    }

    public int getDuration() {
        return this.duration;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<ClocheRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<ClocheRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("seed").forGetter(ClocheRecipe::seed), (App)Ingredient.CODEC.fieldOf("soil").forGetter(ClocheRecipe::soil), (App)Ingredient.CODEC.optionalFieldOf("catalyst", (Object)Ingredient.EMPTY).forGetter(ClocheRecipe::catalyst), (App)Codec.STRING.optionalFieldOf("dimension", (Object)"all").forGetter(ClocheRecipe::dimension), (App)Codec.INT.fieldOf("duration").forGetter(ClocheRecipe::duration), (App)Codec.list((Codec)ChanceResult.CODEC).fieldOf("results").flatXmap(chanceResults -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)chanceResults);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(ClocheRecipe::getRollResults), (App)ItemStack.CODEC.optionalFieldOf("shears_result", (Object)ItemStack.EMPTY).forGetter(ClocheRecipe::shearsResult)).apply((Applicative)instance, ClocheRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, ClocheRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<ClocheRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ClocheRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static ClocheRecipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient seed = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient soil = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient catalyst = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            String dimension = buffer.readUtf(Short.MAX_VALUE);
            int duration = buffer.readInt();
            int size = buffer.readVarInt();
            NonNullList outputs = NonNullList.withSize((int)size, (Object)ChanceResult.EMPTY);
            outputs.replaceAll(ignored -> ChanceResult.read((RegistryFriendlyByteBuf)buffer));
            ItemStack shearsResult = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            return new ClocheRecipe(seed, soil, catalyst, dimension, duration, (NonNullList<ChanceResult>)outputs, shearsResult);
        }

        private static void write(RegistryFriendlyByteBuf buffer, ClocheRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.seed);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.soil);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.catalyst);
            buffer.writeUtf(recipe.dimension, Short.MAX_VALUE);
            buffer.writeInt(recipe.duration);
            buffer.writeVarInt(recipe.results.size());
            for (ChanceResult output : recipe.results) {
                output.write(buffer);
            }
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.shearsResult);
        }
    }

    public static class Type
    implements RecipeType<ClocheRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

