/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.cloche.block.entity;

import com.benbenlaw.cloche.recipe.SpeedUpgradeRecipe;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemStackHandler;

public class SpeedUpgradeLogic {
    public int getNewDuration(int recipeStartAmount, ItemStackHandler itemHandler, Level level) {
        List speedRecipe = level.getRecipeManager().getAllRecipesFor((RecipeType)SpeedUpgradeRecipe.Type.INSTANCE);
        double adjustedDuration = recipeStartAmount;
        ItemStack upgradeSlot1 = itemHandler.getStackInSlot(3);
        ItemStack upgradeSlot2 = itemHandler.getStackInSlot(4);
        ItemStack upgradeSlot3 = itemHandler.getStackInSlot(5);
        ItemStack[] upgradeSlots = new ItemStack[]{upgradeSlot1, upgradeSlot2, upgradeSlot3};
        double totalPercentageReduction = 0.0;
        int totalFixedReduction = 0;
        for (ItemStack upgradeSlot : upgradeSlots) {
            if (upgradeSlot.isEmpty()) continue;
            for (RecipeHolder recipeHolder : speedRecipe) {
                SpeedUpgradeRecipe speedUpgradeRecipe = (SpeedUpgradeRecipe)recipeHolder.value();
                if (!speedUpgradeRecipe.ingredient().test(upgradeSlot)) continue;
                String modifierType = speedUpgradeRecipe.modifierType();
                if (Objects.equals(modifierType, "percentage")) {
                    totalPercentageReduction += (double)speedUpgradeRecipe.duration();
                }
                if (!Objects.equals(modifierType, "fixed")) continue;
                totalFixedReduction += speedUpgradeRecipe.duration();
            }
        }
        adjustedDuration -= (double)recipeStartAmount * (totalPercentageReduction / 100.0);
        return (adjustedDuration -= (double)totalFixedReduction) < 1.0 ? Integer.MAX_VALUE : (int)Math.round(adjustedDuration);
    }
}

