/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.AbstractRedstoneReceivingModule;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;

public class SafetyValveModule
extends AbstractRedstoneReceivingModule {
    private boolean inited = false;

    public SafetyValveModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
    }

    @Override
    public Item getItem() {
        return (Item)ModItems.SAFETY_TUBE_MODULE.get();
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (!this.inited) {
            PNCCapabilities.getAirHandler(this.pressureTube).ifPresent(h -> h.enableSafetyVenting(pressure -> pressure > this.getThreshold(), this.getDirection()));
            this.inited = true;
        }
    }

    @Override
    public float getThreshold() {
        if (this.upgraded) {
            return super.getThreshold();
        }
        return this.getTube().getDangerPressure() == 20.0f ? 19.9f : 4.92f;
    }

    @Override
    public void onRemoved() {
        if (!this.pressureTube.nonNullLevel().isClientSide) {
            PNCCapabilities.getAirHandler(this.pressureTube).ifPresent(h -> {
                h.disableSafetyVenting();
                h.setSideLeaking(null);
            });
        }
    }
}

