/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketUpdateArmorColors(int[][] cols, int eyepiece) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketUpdateArmorColors> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("update_armor_colors"));
    public static final StreamCodec<FriendlyByteBuf, PacketUpdateArmorColors> STREAM_CODEC = StreamCodec.of(PacketUpdateArmorColors::write, PacketUpdateArmorColors::fromNetwork);

    public static PacketUpdateArmorColors forPlayer(Player player) {
        int n;
        int[][] cols = new int[4][2];
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            ItemStack stack = player.getItemBySlot(slot);
            Item item = stack.getItem();
            if (!(item instanceof PneumaticArmorItem)) continue;
            PneumaticArmorItem p = (PneumaticArmorItem)item;
            cols[slot.getIndex()][0] = p.getPrimaryColor(stack);
            cols[slot.getIndex()][1] = p.getSecondaryColor(stack);
        }
        ItemStack stack = player.getItemBySlot(EquipmentSlot.HEAD);
        Item item = stack.getItem();
        if (item instanceof PneumaticArmorItem) {
            PneumaticArmorItem p = (PneumaticArmorItem)item;
            n = p.getEyepieceColor(stack);
        } else {
            n = 0;
        }
        int eyepiece = n;
        return new PacketUpdateArmorColors(cols, eyepiece);
    }

    public static PacketUpdateArmorColors fromNetwork(FriendlyByteBuf buffer) {
        int[][] cols = new int[4][2];
        for (int i = 0; i < cols.length; ++i) {
            cols[i][0] = buffer.readInt();
            cols[i][1] = buffer.readInt();
        }
        return new PacketUpdateArmorColors(cols, buffer.readInt());
    }

    public static void write(FriendlyByteBuf buffer, PacketUpdateArmorColors message) {
        for (int[] col : message.cols) {
            buffer.writeInt(col[0]);
            buffer.writeInt(col[1]);
        }
        buffer.writeInt(message.eyepiece);
    }

    public CustomPacketPayload.Type<PacketUpdateArmorColors> type() {
        return TYPE;
    }

    public static void handle(PacketUpdateArmorColors message, IPayloadContext ctx) {
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            ItemStack stack = ctx.player().getItemBySlot(slot);
            Item item = stack.getItem();
            if (!(item instanceof PneumaticArmorItem)) continue;
            PneumaticArmorItem p = (PneumaticArmorItem)item;
            p.setPrimaryColor(stack, message.cols()[slot.getIndex()][0]);
            p.setSecondaryColor(stack, message.cols()[slot.getIndex()][1]);
        }
        ItemStack stack = ctx.player().getItemBySlot(EquipmentSlot.HEAD);
        Item item = stack.getItem();
        if (item instanceof PneumaticArmorItem) {
            PneumaticArmorItem p = (PneumaticArmorItem)item;
            p.setEyepieceColor(stack, message.eyepiece());
        }
    }
}

