/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammableControllerBlockEntity;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public interface DronePacket
extends CustomPacketPayload {
    public static void handle(DronePacket message, IPayloadContext ctx) {
        Player player = ctx.player();
        Level level = player.level();
        if (message.entityId() >= 0) {
            Entity entity = level.getEntity(message.entityId());
            if (entity instanceof DroneEntity) {
                DroneEntity drone = (DroneEntity)entity;
                message.handle(player, drone);
            }
        } else if (message.pos() != null) {
            BlockEntity te = level.getBlockEntity(message.pos());
            if (te instanceof ProgrammableControllerBlockEntity) {
                ProgrammableControllerBlockEntity pc = (ProgrammableControllerBlockEntity)te;
                message.handle(player, pc);
            }
        } else {
            message.handle(player, null);
        }
    }

    default public int entityId() {
        return this.droneTarget().idOrPos.left().orElse(-1);
    }

    default public BlockPos pos() {
        return this.droneTarget().idOrPos.right().orElse(null);
    }

    public DroneTarget droneTarget();

    public void handle(Player var1, IDroneBase var2);

    public record DroneTarget(Either<Integer, BlockPos> idOrPos) {
        public static final DroneTarget NONE = new DroneTarget((Either<Integer, BlockPos>)Either.left((Object)-1));
        public static final Codec<DroneTarget> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.either((Codec)Codec.INT, (Codec)BlockPos.CODEC).fieldOf("id_or_pos").forGetter(DroneTarget::idOrPos)).apply((Applicative)builder, DroneTarget::new));
        public static final StreamCodec<FriendlyByteBuf, DroneTarget> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.either((StreamCodec)ByteBufCodecs.INT, (StreamCodec)BlockPos.STREAM_CODEC), DroneTarget::idOrPos, DroneTarget::new);

        public static DroneTarget forEntityId(int entityId) {
            return new DroneTarget((Either<Integer, BlockPos>)Either.left((Object)entityId));
        }

        public static DroneTarget forPos(BlockPos pos) {
            return new DroneTarget((Either<Integer, BlockPos>)Either.right((Object)pos));
        }

        public static DroneTarget none() {
            return NONE;
        }

        public boolean is(Entity e) {
            return (Boolean)this.idOrPos.map(id -> id.intValue() == e.getId(), pos -> false);
        }

        public boolean is(BlockPos p) {
            return (Boolean)this.idOrPos.map(id -> false, arg_0 -> ((BlockPos)p).equals(arg_0));
        }

        public IDroneBase getDrone(Level level) {
            return this == NONE ? null : (IDroneBase)this.idOrPos.map(id -> {
                IDroneBase drone;
                Entity patt0$temp = level.getEntity(id.intValue());
                return patt0$temp instanceof IDroneBase ? (drone = (IDroneBase)patt0$temp) : null;
            }, pos -> {
                IDroneBase drone;
                BlockEntity patt0$temp = level.getBlockEntity(pos);
                return patt0$temp instanceof IDroneBase ? (drone = (IDroneBase)patt0$temp) : null;
            });
        }
    }
}

