/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.processing.AssemblyControllerBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.processing.IAssemblyMachine;
import me.desht.pneumaticcraft.common.inventory.AssemblyControllerMenu;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AssemblyControllerScreen
extends AbstractPneumaticCraftContainerScreen<AssemblyControllerMenu, AssemblyControllerBlockEntity> {
    private WidgetAnimatedStat statusStat;

    public AssemblyControllerScreen(AssemblyControllerMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.statusStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status", new Object[0]), new ItemStack((ItemLike)ModBlocks.ASSEMBLY_CONTROLLER.get()), -22016, false);
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        super.renderLabels(graphics, x, y);
        graphics.drawString(this.font, "Prog.", 70, 24, 0x404040, false);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_ASSEMBLY_CONTROLLER;
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.statusStat.setText(this.getStatusText());
    }

    private List<Component> getStatusText() {
        ArrayList<Component> text = new ArrayList<Component>();
        EnumSet<AssemblyProgram.EnumMachine> foundMachines = EnumSet.of(AssemblyProgram.EnumMachine.CONTROLLER);
        for (IAssemblyMachine machine : ((AssemblyControllerBlockEntity)this.te).findMachines(AssemblyProgram.EnumMachine.values().length)) {
            foundMachines.add(machine.getAssemblyType());
        }
        for (AssemblyProgram.EnumMachine m : AssemblyProgram.EnumMachine.values()) {
            if (m == AssemblyProgram.EnumMachine.CONTROLLER) continue;
            MutableComponent s = foundMachines.contains(m) ? Component.literal((String)"\u2714").withStyle(ChatFormatting.DARK_GREEN) : Component.literal((String)"\u2717").withStyle(ChatFormatting.RED);
            text.add((Component)s.append(" ").append((Component)PneumaticCraftUtils.xlate(m.getTranslationKey(), new Object[0]).withStyle(ChatFormatting.WHITE)));
        }
        return text;
    }

    @Override
    protected void addProblems(List<Component> textList) {
        super.addProblems(textList);
        if (((AssemblyControllerBlockEntity)this.te).curProgram == null) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.assembly_controller.no_program", new Object[0]));
        } else if (((AssemblyControllerBlockEntity)this.te).isMachineDuplicate) {
            String s = ((AssemblyControllerBlockEntity)this.te).duplicateMachine == null ? "<???>" : I18n.get((String)((AssemblyControllerBlockEntity)this.te).duplicateMachine.getTranslationKey(), (Object[])new Object[0]);
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.assembly_controller.duplicateMachine", s));
        } else if (((AssemblyControllerBlockEntity)this.te).isMachineMissing) {
            String s = ((AssemblyControllerBlockEntity)this.te).missingMachine == null ? "<???>" : I18n.get((String)((AssemblyControllerBlockEntity)this.te).missingMachine.getTranslationKey(), (Object[])new Object[0]);
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.assembly_controller.missingMachine", s));
        } else {
            ((AssemblyControllerBlockEntity)this.te).curProgram.addProgramProblem(textList);
        }
    }
}

