/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.util;

import de.cadentem.quality_food.core.attachments.AttachmentHandler;
import de.cadentem.quality_food.core.attachments.BlockData;
import de.cadentem.quality_food.core.attachments.LevelData;
import de.cadentem.quality_food.core.codecs.Quality;
import de.cadentem.quality_food.core.codecs.QualityType;
import de.cadentem.quality_food.data.QFBlockTags;
import de.cadentem.quality_food.data.QFItemTags;
import de.cadentem.quality_food.network.CookingParticles;
import de.cadentem.quality_food.util.QualityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static final ThreadLocal<ItemStack> LAST_STACK = new ThreadLocal();

    public static boolean isValidItem(ItemStack stack) {
        return Utils.isValidItem(stack, true);
    }

    public static boolean isValidItem(ItemStack stack, boolean checkBlock) {
        BlockItem blockItem;
        Item item;
        if (stack.isEmpty()) {
            return false;
        }
        if (stack.is(QFItemTags.BLACKLIST)) {
            return false;
        }
        FoodProperties properties = stack.getFoodProperties(null);
        if (properties != null && (properties.nutrition() > 0 || properties.saturation() > 0.0f)) {
            return true;
        }
        if (checkBlock && (item = stack.getItem()) instanceof BlockItem && Utils.isValidBlock((blockItem = (BlockItem)item).getBlock(), false)) {
            return true;
        }
        return stack.is(QFItemTags.MATERIAL_WHITELIST);
    }

    public static boolean isValidBlock(Block block) {
        return Utils.isValidBlock(block, true);
    }

    public static boolean isValidBlock(Block block, boolean checkItem) {
        if (block.builtInRegistryHolder().is(QFBlockTags.QUALITY_BLOCKS)) {
            return true;
        }
        if (checkItem) {
            return Utils.isValidItem(block.asItem().getDefaultInstance(), false);
        }
        return false;
    }

    public static void sendParticles(ServerLevel serverLevel, BlockEntity furnace, BlockPos position) {
        BlockData data;
        double qualityBonus;
        int tickOffset = serverLevel.getRandom().nextInt(-3, 3);
        if (serverLevel.getGameTime() % (long)(10 + tickOffset) == 0L && (qualityBonus = (data = (BlockData)furnace.getData(AttachmentHandler.BLOCK_DATA)).getQuality()) > 0.1) {
            PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)position.getX(), (double)position.getY(), (double)position.getZ(), (double)64.0, (CustomPacketPayload)new CookingParticles(position, qualityBonus), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void storeQuality(BlockState grown, ServerLevel accessor, BlockPos position, Direction direction) {
        Utils.storeQuality(grown, accessor, position, position.relative(direction), 1.0);
    }

    public static void storeQuality(BlockState grown, ServerLevel accessor, BlockPos position, BlockPos grownPosition) {
        Utils.storeQuality(grown, accessor, position, grownPosition, 1.0);
    }

    public static void storeQuality(BlockState grown, ServerLevel level, BlockPos position, BlockPos grownPosition, double chance) {
        if (Utils.isValidBlock(grown.getBlock())) {
            LevelData data = (LevelData)level.getData(AttachmentHandler.LEVEL_DATA);
            Quality quality = data.get(position);
            if (Math.random() > chance) {
                quality = Quality.getRandom(ItemStack.EMPTY, quality.level() - 1);
            }
            if (quality.level() > 0) {
                data.set(grownPosition, quality);
            }
        }
    }

    public static void incrementQuality(BlockEntity blockEntity, ItemStack stack) {
        Utils.incrementQuality(blockEntity, stack, 1);
    }

    public static void incrementQuality(BlockEntity blockEntity, ItemStack stack, int ingredientCount) {
        if (blockEntity.getLevel() == null || blockEntity.getLevel().isClientSide() || ingredientCount < 1) {
            return;
        }
        if (!Utils.isValidItem(stack)) {
            return;
        }
        Holder<QualityType> type = QualityUtils.getType(stack);
        BlockData data = (BlockData)blockEntity.getData(AttachmentHandler.BLOCK_DATA);
        data.addQualityType(type);
        if (type.value() != QualityType.NONE) {
            data.incrementQuality(((QualityType)type.value()).cookingBonus() / (double)ingredientCount);
        }
        blockEntity.setChanged();
    }

    public static void useQuality(BlockEntity block, ItemStack stack, @Nullable Player player) {
        BlockData data = (BlockData)block.getData(AttachmentHandler.BLOCK_DATA);
        data.useQuality(stack, player);
        block.setChanged();
    }
}

