/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.util;

import com.mojang.datafixers.util.Pair;
import de.cadentem.quality_food.compat.Compat;
import de.cadentem.quality_food.config.ServerConfig;
import de.cadentem.quality_food.core.Bonus;
import de.cadentem.quality_food.core.codecs.Quality;
import de.cadentem.quality_food.core.codecs.QualityType;
import de.cadentem.quality_food.registry.QFComponents;
import de.cadentem.quality_food.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.WildCropBlock;

public class QualityUtils {
    private static final RandomSource RANDOM = RandomSource.create();

    public static boolean hasQuality(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        Quality quality = (Quality)stack.get(QFComponents.QUALITY_DATA_COMPONENT);
        if (quality == null) {
            return false;
        }
        return quality.level() > 0;
    }

    public static float getQualityBonus(List<Slot> slots, Predicate<Slot> isSlotValid) {
        int validIngredients = 0;
        float bonus = 0.0f;
        for (Slot slot : slots) {
            if (!isSlotValid.test(slot) || !Utils.isValidItem(slot.getItem())) continue;
            ++validIngredients;
        }
        if (validIngredients == 0) {
            return 0.0f;
        }
        for (Slot slot : slots) {
            Holder<QualityType> type;
            if (!isSlotValid.test(slot) || (type = QualityUtils.getType(slot.getItem())).value() == QualityType.NONE) continue;
            bonus += (float)(((QualityType)type.value()).craftingBonus() / (double)validIngredients);
        }
        return bonus;
    }

    public static float getQualityBonus(CraftingContainer container) {
        int validIngredients = QualityUtils.countIngredients(container);
        if (validIngredients == 0) {
            return 0.0f;
        }
        float bonus = 0.0f;
        for (ItemStack ingredient : container.getItems()) {
            Holder<QualityType> type = QualityUtils.getType(ingredient);
            if (type.value() == QualityType.NONE) continue;
            bonus += (float)(((QualityType)type.value()).craftingBonus() / (double)validIngredients);
        }
        return bonus;
    }

    public static void applyQuality(ItemStack stack) {
        QualityUtils.applyQuality(stack, null, Bonus.DEFAULT);
    }

    public static void applyQuality(ItemStack stack, @NotNull Bonus bonus) {
        QualityUtils.applyQuality(stack, null, bonus);
    }

    public static void applyQuality(ItemStack stack, @Nullable Entity entity) {
        QualityUtils.applyQuality(stack, entity, Bonus.DEFAULT);
    }

    public static void applyQuality(ItemStack stack, @Nullable Entity entity, @NotNull Bonus bonus) {
        ArrayList<Bonus> bonusList = new ArrayList<Bonus>();
        bonusList.add(bonus);
        QualityUtils.applyQuality(stack, entity, bonusList);
    }

    public static void applyQuality(ItemStack stack, @Nullable Entity entity, @NotNull List<Bonus> bonusList) {
        if (Utils.LAST_STACK.get() == stack) {
            return;
        }
        Utils.LAST_STACK.set(stack);
        QualityUtils.applyQuality(stack, entity, bonusList, false);
    }

    public static void applyQuality(ItemStack stack, @Nullable Entity entity, @NotNull List<Bonus> bonusList, boolean canUpgrade) {
        HolderLookup.RegistryLookup lookup;
        double d;
        RandomSource random;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            v0 = livingEntity.getRandom();
        } else {
            v0 = random = RANDOM;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            d = (double)player.getLuck() * (Double)ServerConfig.LUCK_MULTIPLIER.get();
        } else {
            d = 0.0;
        }
        double rolls = 1.0 + d;
        if (rolls < 0.0) {
            rolls = 0.1;
        }
        if ((lookup = CommonHooks.resolveLookup(QFComponents.QUALITY_TYPE_REGISTRY)) == null) {
            return;
        }
        ArrayList<Object> types = new ArrayList<Object>();
        if (canUpgrade) {
            Holder<QualityType> type2 = QualityUtils.getType(stack);
            lookup.listElements().forEach(entry -> {
                if (((QualityType)entry.value()).level() > ((QualityType)type2.value()).level()) {
                    types.add(entry);
                }
            });
        } else {
            lookup.listElements().forEach(types::add);
        }
        if (types.isEmpty()) {
            return;
        }
        types.sort(Comparator.comparingInt(type -> ((QualityType)((Holder)type).value()).level()).reversed());
        float roll = random.nextFloat();
        int fullRolls = (int)rolls;
        if (random.nextDouble() <= rolls - (double)fullRolls) {
            ++fullRolls;
        }
        block4: for (int i = 0; i < fullRolls; ++i) {
            for (Holder holder : types) {
                boolean wasApplied;
                double chance = ((QualityType)holder.value()).chance();
                for (Bonus bonus : bonusList) {
                    chance = switch (bonus.type()) {
                        default -> throw new MatchException(null, null);
                        case Bonus.Type.ADDITIVE -> chance + (double)bonus.amount();
                        case Bonus.Type.MULTIPLICATIVE -> chance * (double)bonus.amount();
                    };
                }
                if (!((double)roll <= chance) || !(wasApplied = QualityUtils.applyQuality(stack, QualityType.createQuality((Holder<QualityType>)holder, stack), canUpgrade))) continue;
                continue block4;
            }
        }
    }

    public static boolean applyQuality(ItemStack stack, Holder<QualityType> type) {
        return QualityUtils.applyQuality(stack, QualityType.createQuality(type, stack));
    }

    public static boolean applyQuality(ItemStack stack, Quality quality) {
        return QualityUtils.applyQuality(stack, quality, false);
    }

    public static boolean applyQuality(ItemStack stack, Quality quality, boolean canUpgrade) {
        if (!QualityUtils.isValidQuality(quality) || !Utils.isValidItem(stack)) {
            return false;
        }
        if (!canUpgrade && QualityUtils.hasQuality(stack) || QualityUtils.getQuality(stack).level() > quality.level()) {
            return false;
        }
        stack.set(QFComponents.QUALITY_DATA_COMPONENT, (Object)quality);
        return true;
    }

    public static void applyQuality(ItemStack stack, @NotNull Quality quality, @NotNull BlockState state, @Nullable Player player, @Nullable BlockState farmland) {
        if (farmland == null) {
            QualityUtils.applyQuality(stack, quality, state, player);
            return;
        }
        double farmlandMultiplier = ServerConfig.getFarmlandMultiplier(state, farmland);
        if (farmlandMultiplier == -1.0) {
            QualityUtils.applyQuality(stack, quality, state, player);
        } else {
            Bonus farmlandBonus = Bonus.multiplicative((float)farmlandMultiplier);
            ArrayList<Bonus> bonusList = new ArrayList<Bonus>();
            bonusList.add(farmlandBonus);
            QualityUtils.applyQuality(stack, quality, state, player, bonusList);
        }
    }

    public static void applyQuality(ItemStack stack, @NotNull Quality quality, @NotNull BlockState state, @Nullable Player player) {
        QualityUtils.applyQuality(stack, quality, state, player, new ArrayList<Bonus>());
    }

    public static void applyQuality(ItemStack stack, @NotNull Quality quality, @NotNull BlockState state, @Nullable Player player, @NotNull List<Bonus> bonusList) {
        if (QualityUtils.isRelevantCrop(state)) {
            float targetChance = ((Double)ServerConfig.CROP_TARGET_CHANCE.get()).floatValue();
            if (stack.is(Tags.Items.SEEDS)) {
                targetChance = (float)((double)targetChance * (Double)ServerConfig.SEED_CHANCE_MULTIPLIER.get());
            }
            if (targetChance > 0.0f && quality.level() > 0) {
                bonusList.add(Bonus.multiplicative((float)((double)targetChance / ((QualityType)quality.getType().value()).chance())));
            }
            QualityUtils.applyQuality(stack, (Entity)player, bonusList);
        } else if (QualityUtils.isValidQuality(quality)) {
            QualityUtils.applyQuality(stack, quality);
        } else if (quality != Quality.PLAYER_PLACED) {
            QualityUtils.applyQuality(stack, (Entity)player);
        }
    }

    private static boolean isRelevantCrop(BlockState state) {
        CropBlock crop;
        Block block = state.getBlock();
        if (block instanceof CropBlock && (crop = (CropBlock)block).isMaxAge(state)) {
            return true;
        }
        if (Compat.isModLoaded("farmersdelight") && state.getBlock() instanceof WildCropBlock) {
            return true;
        }
        return Compat.isModLoaded("farm_and_charm") && state.is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Compat.location("farm_and_charm", "wild_crops")));
    }

    public static void handleConversion(@NotNull ItemStack result, @NotNull Container container, @Nullable RecipeHolder<?> recipe, @Nullable RegistryAccess access) {
        boolean isRecipe = ServerConfig.isRetainQualityRecipe(recipe, access);
        boolean handleCompacting = (Boolean)ServerConfig.HANDLE_COMPACTING.get();
        if (!isRecipe && !handleCompacting) {
            return;
        }
        Pair<HashMap<Item, Integer>, HashMap<Integer, Integer>> data = QualityUtils.getContainerData(container);
        int relevantItemCount = ((HashMap)data.getFirst()).entrySet().stream().mapToInt(entry -> {
            if (Utils.isValidItem(((Item)entry.getKey()).getDefaultInstance())) {
                return (Integer)entry.getValue();
            }
            return 0;
        }).sum();
        Quality quality = QualityUtils.getQuality((HashMap)data.getSecond(), relevantItemCount, result);
        if (quality.level() > 0 && (isRecipe || QualityUtils.getCompactingSize((HashMap)data.getFirst(), container) == relevantItemCount || relevantItemCount == 1 && (result.getCount() == 4 || result.getCount() == 9))) {
            QualityUtils.applyQuality(result, quality);
        }
    }

    public static boolean isInvalidItem(ItemStack stack) {
        return QualityUtils.hasQuality(stack) || !Utils.isValidItem(stack);
    }

    private static Pair<HashMap<Item, Integer>, HashMap<Integer, Integer>> getContainerData(Container container) {
        HashMap<Integer, Integer> qualities = new HashMap<Integer, Integer>();
        HashMap<Item, Integer> items = new HashMap<Item, Integer>();
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack containerStack = container.getItem(i);
            Item item = containerStack.getItem();
            items.put(item, items.getOrDefault(item, 0) + 1);
            if (!Utils.isValidItem(containerStack)) continue;
            Quality quality = QualityUtils.getQuality(containerStack);
            qualities.compute(quality.level(), (key, value) -> value == null ? 1 : value + 1);
        }
        return Pair.of(items, qualities);
    }

    private static Quality getQuality(HashMap<Integer, Integer> qualities, int itemCount, ItemStack result) {
        if (itemCount == 0) {
            return Quality.NONE;
        }
        List<Integer> levels = qualities.keySet().stream().sorted(Comparator.comparingInt(Integer::intValue).reversed()).toList();
        for (Integer level : levels) {
            if ((itemCount -= qualities.get(level).intValue()) > 0) continue;
            return Quality.getRandom(result, level);
        }
        return Quality.NONE;
    }

    private static int getCompactingSize(HashMap<Item, Integer> items, Container container) {
        Set<Item> keys = items.keySet();
        if (!(keys.size() == 1 || keys.size() == 2 && keys.contains(Items.AIR))) {
            return -1;
        }
        int containerSize = container.getContainerSize();
        int result = -1;
        for (Item key : keys) {
            int itemCount = items.get(key);
            if (key == Items.AIR && containerSize - itemCount - 4 != 0 && containerSize - itemCount - 9 != 0) {
                return -1;
            }
            if (key == Items.AIR || itemCount != 4 && itemCount != 9) continue;
            result = itemCount;
        }
        return result;
    }

    public static Quality getQuality(@Nullable ItemStack stack) {
        if (stack == null) {
            return Quality.NONE;
        }
        Quality quality = (Quality)stack.get(QFComponents.QUALITY_DATA_COMPONENT);
        if (quality == null) {
            return Quality.NONE;
        }
        return quality;
    }

    public static Holder<QualityType> getType(ItemStack stack) {
        return QualityUtils.getQuality(stack).getType();
    }

    public static boolean isValidQuality(Quality quality) {
        return quality != null && quality.level() > 0;
    }

    public static int countIngredients(CraftingContainer container) {
        int count = 0;
        for (ItemStack stack : container.getItems()) {
            if (!Utils.isValidItem(stack)) continue;
            ++count;
        }
        return count;
    }
}

