/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.util;

import de.cadentem.quality_food.core.codecs.Quality;
import de.cadentem.quality_food.core.codecs.QualityType;
import de.cadentem.quality_food.data.QFEffectTags;
import de.cadentem.quality_food.registry.QFComponents;
import de.cadentem.quality_food.util.QualityUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoodUtils {
    @Nullable
    public static FoodProperties handleFoodProperties(ItemStack stack, @Nullable FoodProperties original) {
        if (original == null || !QualityUtils.hasQuality(stack)) {
            return original;
        }
        Holder<QualityType> holder = QualityUtils.getType(stack);
        QualityType type = (QualityType)holder.value();
        if (type == QualityType.NONE) {
            return original;
        }
        FoodProperties.Builder builder = FoodUtils.getBuilder(original, type);
        List originalEffects = original.effects();
        Optional blacklist = BuiltInRegistries.MOB_EFFECT.getTag(QFEffectTags.BLACKLIST);
        originalEffects.forEach(originalData -> {
            Optional<MobEffectInstance> optional = FoodUtils.modifyEffect(originalData.effect(), type, blacklist);
            optional.ifPresent(instance -> {
                float probability = originalData.probability();
                if (blacklist.isEmpty() || !((HolderSet.Named)blacklist.get()).contains(instance.getEffect())) {
                    if (((MobEffect)instance.getEffect().value()).isBeneficial()) {
                        probability = (float)((double)probability * type.probabilityMultiplier());
                    } else if (((MobEffect)instance.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL) {
                        probability = type.probabilityMultiplier() == 0.0 ? 0.0f : (float)((double)probability / type.probabilityMultiplier());
                    }
                }
                if (probability > 0.0f) {
                    builder.effect(() -> instance, Mth.clamp((float)probability, (float)0.0f, (float)1.0f));
                }
            });
        });
        Optional<List<FoodProperties.PossibleEffect>> effects = FoodUtils.getEffects(stack);
        effects.ifPresent(entries -> entries.forEach(entry -> builder.effect(() -> ((FoodProperties.PossibleEffect)entry).effect(), entry.probability())));
        return builder.build();
    }

    public static Optional<MobEffectInstance> modifyEffect(MobEffectInstance instance, QualityType type) {
        return FoodUtils.modifyEffect(instance, type, BuiltInRegistries.MOB_EFFECT.getTag(QFEffectTags.BLACKLIST));
    }

    public static Optional<MobEffectInstance> modifyEffect(MobEffectInstance instance, QualityType type, Optional<HolderSet.Named<MobEffect>> blacklist) {
        if (type == QualityType.NONE) {
            return Optional.of(instance);
        }
        Holder effect = instance.getEffect();
        int duration = instance.getDuration();
        int amplifier = instance.getAmplifier();
        if (blacklist.isEmpty() || !blacklist.get().contains(effect)) {
            if (((MobEffect)effect.value()).isBeneficial()) {
                duration = (int)((double)duration * type.durationMultiplier());
                amplifier += type.amplifierModifier();
            } else if (((MobEffect)effect.value()).getCategory() == MobEffectCategory.HARMFUL) {
                duration = type.durationMultiplier() == 0.0 ? 0 : (int)((double)duration / type.durationMultiplier());
                amplifier -= type.amplifierModifier();
            }
            if (amplifier >= 0 && duration > 0) {
                return Optional.of(new MobEffectInstance(effect, duration, amplifier));
            }
            return Optional.empty();
        }
        return Optional.of(instance);
    }

    public static Optional<List<FoodProperties.PossibleEffect>> getEffects(@Nullable ItemStack stack) {
        if (stack == null) {
            return Optional.empty();
        }
        Quality quality = (Quality)stack.get(QFComponents.QUALITY_DATA_COMPONENT);
        if (quality != null) {
            return quality.effects();
        }
        return Optional.empty();
    }

    @NotNull
    private static FoodProperties.Builder getBuilder(@NotNull FoodProperties original, QualityType type) {
        int nutrition = (int)((double)original.nutrition() * type.nutritionMultiplier());
        float originalSaturationModifier = original.saturation() / (float)original.nutrition() / 2.0f;
        float saturationModifier = (float)((double)originalSaturationModifier * type.saturationMultiplier());
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.nutrition(nutrition);
        builder.saturationModifier(saturationModifier);
        if (original.canAlwaysEat()) {
            builder.alwaysEdible();
        }
        if (original.eatSeconds() == 0.8f) {
            builder.fast();
        }
        return builder;
    }
}

