/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.registry;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.cadentem.quality_food.core.codecs.QualityType;
import de.cadentem.quality_food.core.commands.QualityItemArgument;
import de.cadentem.quality_food.core.commands.QualityTypeArgument;
import de.cadentem.quality_food.registry.QFComponents;
import de.cadentem.quality_food.util.QualityUtils;
import de.cadentem.quality_food.util.Utils;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public class QFCommands {
    public static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENTS = DeferredRegister.create((ResourceKey)Registries.COMMAND_ARGUMENT_TYPE, (String)"quality_food");

    public static void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"quality_food").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"give").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"quality_type", (ArgumentType)new QualityTypeArgument(event.getBuildContext())).then(((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)QualityItemArgument.item(event.getBuildContext())).executes(context -> QFCommands.giveItem((CommandSourceStack)context.getSource(), ItemArgument.getItem((CommandContext)context, (String)"item"), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), 1, QualityTypeArgument.get(context)))).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> QFCommands.giveItem((CommandSourceStack)context.getSource(), ItemArgument.getItem((CommandContext)context, (String)"item"), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), QualityTypeArgument.get(context))))))))).then(Commands.literal((String)"apply").then(((RequiredArgumentBuilder)Commands.argument((String)"quality_type", (ArgumentType)new QualityTypeArgument(event.getBuildContext())).executes(context -> QFCommands.applyQuality((CommandSourceStack)context.getSource(), QualityTypeArgument.get(context), false))).then(Commands.argument((String)"override", (ArgumentType)BoolArgumentType.bool()).executes(context -> QFCommands.applyQuality((CommandSourceStack)context.getSource(), QualityTypeArgument.get(context), BoolArgumentType.getBool((CommandContext)context, (String)"override"))))))).then(Commands.literal((String)"remove").executes(context -> QFCommands.removeQuality((CommandSourceStack)context.getSource()))));
    }

    private static int applyQuality(CommandSourceStack source, Holder<QualityType> type, boolean shouldOverride) {
        if (((QualityType)type.value()).level() <= 0) {
            source.sendFailure((Component)Component.translatable((String)"commands.quality_food.quality.failed.invalid_quality"));
            return 0;
        }
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingSource = (LivingEntity)entity;
            ItemStack stack = livingSource.getMainHandItem();
            if (!Utils.isValidItem(stack)) {
                source.sendFailure((Component)Component.translatable((String)"commands.quality_food.quality.failed.no_quality", (Object[])new Object[]{stack.getDisplayName()}));
                return 0;
            }
            if (QualityUtils.hasQuality(stack) && !shouldOverride) {
                source.sendFailure((Component)Component.translatable((String)"commands.quality_food.quality.failed.already_has_quality", (Object[])new Object[]{stack.getDisplayName()}));
                return 0;
            }
            if (shouldOverride && stack.has(QFComponents.QUALITY_DATA_COMPONENT)) {
                stack.remove(QFComponents.QUALITY_DATA_COMPONENT);
            }
            QualityUtils.applyQuality(stack, type);
            return 1;
        }
        return 0;
    }

    private static int removeQuality(CommandSourceStack source) {
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingSource = (LivingEntity)entity;
            ItemStack stack = livingSource.getMainHandItem();
            if (stack.has(QFComponents.QUALITY_DATA_COMPONENT)) {
                stack.remove(QFComponents.QUALITY_DATA_COMPONENT);
                return 1;
            }
            source.sendFailure((Component)Component.translatable((String)"commands.quality_food.quality.failed.missing_quality", (Object[])new Object[]{stack.getDisplayName()}));
            return 0;
        }
        return 0;
    }

    private static int giveItem(CommandSourceStack source, ItemInput input, Collection<ServerPlayer> players, int count, Holder<QualityType> type) throws CommandSyntaxException {
        if (((QualityType)type.value()).level() <= 0) {
            source.sendFailure((Component)Component.translatable((String)"commands.quality_food.quality.failed.invalid_quality"));
            return 0;
        }
        ItemStack tempStack = input.createItemStack(1, false);
        int maxStackSize = tempStack.getMaxStackSize();
        int maxCount = maxStackSize * 100;
        if (QualityUtils.isInvalidItem(tempStack)) {
            source.sendFailure((Component)Component.translatable((String)"commands.quality_food.quality.failed.no_quality", (Object[])new Object[]{tempStack.getDisplayName()}));
            return 0;
        }
        if (count > maxCount) {
            source.sendFailure((Component)Component.translatable((String)"commands.give.failed.toomanyitems", (Object[])new Object[]{maxCount, tempStack.getDisplayName()}));
            return 0;
        }
        for (ServerPlayer player : players) {
            int toGive = count;
            while (toGive > 0) {
                ItemEntity entity;
                int min = Math.min(toGive, maxStackSize);
                toGive -= min;
                ItemStack stack = input.createItemStack(min, false);
                QualityUtils.applyQuality(stack, type);
                boolean wasAdded = player.getInventory().add(stack);
                if (wasAdded && stack.isEmpty()) {
                    stack.setCount(1);
                    entity = player.drop(stack, false);
                    if (entity != null) {
                        entity.makeFakeItem();
                    }
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (player.getRandom().nextFloat() - player.getRandom().nextFloat() * 0.7f + 1.0f) * 2.0f);
                    player.containerMenu.broadcastChanges();
                    continue;
                }
                entity = player.drop(stack, false);
                if (entity == null) continue;
                entity.setNoPickUpDelay();
                entity.setTarget(player.getUUID());
            }
        }
        if (players.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{count, tempStack.getDisplayName(), ((ServerPlayer)players.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{count, tempStack.getDisplayName(), players.size()}), true);
        }
        return players.size();
    }

    static {
        COMMAND_ARGUMENTS.register("quality_type", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(QualityTypeArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextAware(QualityTypeArgument::new)));
        COMMAND_ARGUMENTS.register("item", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(QualityItemArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextAware(QualityItemArgument::item)));
    }
}

