/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.mixin.smarterfarmers;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import de.cadentem.quality_food.core.attachments.LevelData;
import de.cadentem.quality_food.core.codecs.Quality;
import de.cadentem.quality_food.util.QualityUtils;
import java.util.Map;
import net.mehvahdjukaar.smarterfarmers.SFHarvestFarmland;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SFHarvestFarmland.class}, remap=false)
public abstract class SFHarvestFarmlandMixin {
    @Shadow
    public BlockPos aboveFarmlandPos;

    @Inject(method={"replant"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V", shift=At.Shift.BEFORE)})
    private void quality_food$storeQuality(ServerLevel level, Villager villager, Item item, CallbackInfo callback, @Local ItemStack seed) {
        Quality quality = QualityUtils.getQuality(seed);
        if (quality.level() > 0) {
            LevelData.set((LevelAccessor)level, this.aboveFarmlandPos, quality);
        }
    }

    @WrapOperation(method={"getSeedToPlantAt"}, at={@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;")})
    private <K, V> V quality_food$keepHighestQualitySeed(Map<K, V> inventory, K key, V value, Operation<V> original) {
        V v = inventory.get(key);
        if (v instanceof ItemStack) {
            ItemStack inventoryStack = (ItemStack)v;
            if (value instanceof ItemStack) {
                ItemStack stack = (ItemStack)value;
                if (QualityUtils.getQuality(inventoryStack).level() >= QualityUtils.getQuality(stack).level()) {
                    return null;
                }
            }
        }
        return (V)original.call(new Object[]{inventory, key, value});
    }
}

