/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.mixin;

import de.cadentem.quality_food.config.ServerConfig;
import de.cadentem.quality_food.core.Bonus;
import de.cadentem.quality_food.util.QualityUtils;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ResultSlot.class})
public abstract class ResultSlotMixin
extends Slot {
    @Shadow
    @Final
    private Player player;
    @Shadow
    @Final
    private CraftingContainer craftSlots;

    public ResultSlotMixin(Container container, int slot, int x, int y) {
        super(container, slot, x, y);
    }

    @Inject(method={"checkTakeAchievements"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;onCraftedBy(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;I)V", shift=At.Shift.AFTER)})
    private void quality_food$applyQuality(ItemStack stack, CallbackInfo callback) {
        RecipeCraftingHolder holder;
        Container container;
        if (this.player.level().isClientSide() || (container = this.container) instanceof RecipeCraftingHolder && ServerConfig.isNoQualityRecipe((holder = (RecipeCraftingHolder)container).getRecipeUsed(), this.player.registryAccess())) {
            return;
        }
        QualityUtils.applyQuality(stack, (Entity)this.player, Bonus.additive(QualityUtils.getQualityBonus(this.craftSlots)));
    }
}

