/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.events;

import com.mojang.datafixers.util.Either;
import de.cadentem.quality_food.client.ClientProxy;
import de.cadentem.quality_food.config.ClientConfig;
import de.cadentem.quality_food.core.EffectComponent;
import de.cadentem.quality_food.util.QualityUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber
public class GameEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleFishing(ItemFishedEvent event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        event.getDrops().forEach(drop -> QualityUtils.applyQuality(drop, (Entity)event.getEntity()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleLoot(LivingDropsEvent event) {
        Entity attacker = event.getSource().getEntity();
        if (attacker == null || event.getEntity() instanceof Player) {
            return;
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            event.getDrops().forEach(drop -> QualityUtils.applyQuality(drop.getItem(), (Entity)livingAttacker));
        }
    }

    @SubscribeEvent
    public static void addTooltip(ItemTooltipEvent event) {
        if (ClientConfig.SPEC.isLoaded() && !((Boolean)ClientConfig.EFFECT_TOOLTIPS.get()).booleanValue()) {
            return;
        }
        for (Component component : event.getToolTip()) {
            TranslatableContents contents;
            MutableComponent mutable;
            ComponentContents componentContents;
            if (!(component instanceof MutableComponent) || !((componentContents = (mutable = (MutableComponent)component).getContents()) instanceof TranslatableContents) || !(contents = (TranslatableContents)componentContents).getKey().equals("potion.withDuration")) continue;
            event.getToolTip().remove(component);
            return;
        }
    }

    @SubscribeEvent
    public static void addEffectTooltip(RenderTooltipEvent.GatherComponents event) {
        if (ClientConfig.SPEC.isLoaded() && !((Boolean)ClientConfig.EFFECT_TOOLTIPS.get()).booleanValue()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        FoodProperties properties = stack.getFoodProperties((LivingEntity)ClientProxy.getLocalPlayer());
        if (properties == null) {
            return;
        }
        for (FoodProperties.PossibleEffect possibleEffect : properties.effects()) {
            event.getTooltipElements().add(Either.right((Object)new EffectComponent(possibleEffect)));
        }
    }
}

