/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.data;

import de.cadentem.quality_food.QualityFood;
import de.cadentem.quality_food.core.codecs.QualityType;
import de.cadentem.quality_food.data.QFBlockTags;
import de.cadentem.quality_food.data.QFEffectTags;
import de.cadentem.quality_food.data.QFItemTags;
import de.cadentem.quality_food.data.QFLootModifiers;
import de.cadentem.quality_food.registry.QFComponents;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DataGen {
    @SubscribeEvent
    public static void configureDataGen(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        QFBlockTags blockTags = new QFBlockTags(generator.getPackOutput(), event.getLookupProvider(), helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new QFItemTags(generator.getPackOutput(), event.getLookupProvider(), blockTags.contentsGetter(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new QFLootModifiers(generator.getPackOutput(), event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new QFEffectTags(generator.getPackOutput(), event.getLookupProvider(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(generator.getPackOutput(), event.getLookupProvider(), DataGen.createProvider(), Set.of("quality_food")));
    }

    private static RegistrySetBuilder createProvider() {
        return new RegistrySetBuilder().add(QFComponents.QUALITY_TYPE_REGISTRY, bootstrap -> {
            bootstrap.register(ResourceKey.create(QFComponents.QUALITY_TYPE_REGISTRY, (ResourceLocation)QualityFood.location("iron")), (Object)new QualityType(1, 0.1, 1.5, 1.25, 1, 1.5, 1.25, 0.15, 0.00390625, Optional.empty(), QualityFood.location("quality_icon/iron")));
            bootstrap.register(ResourceKey.create(QFComponents.QUALITY_TYPE_REGISTRY, (ResourceLocation)QualityFood.location("gold")), (Object)new QualityType(2, 0.03, 2.0, 1.5, 2, 2.0, 1.5, 0.4, 0.0078125, Optional.empty(), QualityFood.location("quality_icon/gold")));
            bootstrap.register(ResourceKey.create(QFComponents.QUALITY_TYPE_REGISTRY, (ResourceLocation)QualityFood.location("diamond")), (Object)new QualityType(3, 0.005, 2.5, 2.0, 3, 2.5, 1.75, 0.7, 0.015625, Optional.empty(), QualityFood.location("quality_icon/diamond")));
        });
    }
}

