/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.core.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cadentem.quality_food.QualityFood;
import de.cadentem.quality_food.core.codecs.ChanceEffect;
import de.cadentem.quality_food.core.codecs.Effect;
import de.cadentem.quality_food.core.codecs.Quality;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;

public record QualityType(int level, double chance, double durationMultiplier, double probabilityMultiplier, int amplifierModifier, double nutritionMultiplier, double saturationMultiplier, double craftingBonus, double cookingBonus, Optional<List<Effect>> effects, ResourceLocation icon) {
    public static final QualityType NONE = new QualityType(0, 0.0, 1.0, 1.0, 0, 1.0, 1.0, 0.0, 0.0, Optional.empty(), QualityFood.location("none"));
    private static final RandomSource RANDOM = RandomSource.create();
    public static final Codec<QualityType> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("level").forGetter(QualityType::level), (App)Codec.DOUBLE.fieldOf("chance").forGetter(QualityType::chance), (App)Codec.DOUBLE.optionalFieldOf("duration_multiplier", (Object)1.0).forGetter(QualityType::durationMultiplier), (App)Codec.DOUBLE.optionalFieldOf("probability_multiplier", (Object)1.0).forGetter(QualityType::probabilityMultiplier), (App)Codec.INT.optionalFieldOf("amplifier_modifier", (Object)0).forGetter(QualityType::amplifierModifier), (App)Codec.DOUBLE.fieldOf("nutrition_multiplier").forGetter(QualityType::nutritionMultiplier), (App)Codec.DOUBLE.fieldOf("saturation_multiplier").forGetter(QualityType::saturationMultiplier), (App)Codec.DOUBLE.optionalFieldOf("crafting_bonus", (Object)0.0).forGetter(QualityType::craftingBonus), (App)Codec.DOUBLE.optionalFieldOf("cooking_bonus", (Object)0.0).forGetter(QualityType::cookingBonus), (App)Effect.CODEC.listOf().optionalFieldOf("effects").forGetter(QualityType::effects), (App)ResourceLocation.CODEC.fieldOf("icon").forGetter(QualityType::icon)).apply((Applicative)builder, QualityType::new));

    public QualityType {
        level = Math.max(0, level);
        chance = Math.clamp(chance, 0.0, 1.0);
        durationMultiplier = Math.max(0.0, durationMultiplier);
        probabilityMultiplier = Math.max(0.0, probabilityMultiplier);
        amplifierModifier = Math.clamp((long)amplifierModifier, -255, 255);
        nutritionMultiplier = Math.max(0.0, nutritionMultiplier);
        saturationMultiplier = Math.max(0.0, saturationMultiplier);
        craftingBonus = Math.clamp(craftingBonus, 0.0, 1.0);
        cookingBonus = Math.clamp(cookingBonus, 0.0, 1.0);
    }

    public static Quality createQuality(Holder<QualityType> holder, ItemStack stack) {
        Optional optional;
        ArrayList<FoodProperties.PossibleEffect> effectsToApply = null;
        QualityType type = (QualityType)holder.value();
        if (type.effects.isPresent()) {
            effectsToApply = new ArrayList<FoodProperties.PossibleEffect>();
            for (Effect configuration : type.effects.get()) {
                if (!configuration.test(stack)) continue;
                for (ChanceEffect chanceEffect : configuration.effects()) {
                    if (!(chanceEffect.chance() > 0.0) || !(RANDOM.nextDouble() < chanceEffect.chance())) continue;
                    effectsToApply.add(chanceEffect.effect());
                }
            }
            if (effectsToApply.isEmpty()) {
                effectsToApply = null;
            }
        }
        if ((optional = holder.unwrapKey()).isPresent()) {
            return new Quality(((ResourceKey)optional.get()).location(), type.level, Optional.ofNullable(effectsToApply));
        }
        return Quality.NONE;
    }
}

