/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.core.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cadentem.quality_food.QualityFood;
import de.cadentem.quality_food.core.codecs.QualityType;
import de.cadentem.quality_food.registry.QFComponents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.CommonHooks;

public record Quality(ResourceLocation type, int level, Optional<List<FoodProperties.PossibleEffect>> effects) {
    public static final Quality NONE = new Quality(QualityFood.location("none"), 0, Optional.empty());
    public static final Quality PLAYER_PLACED = new Quality(QualityFood.location("none"), -1, Optional.empty());
    public static final Codec<Quality> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("type").forGetter(Quality::type), (App)Codec.INT.fieldOf("level").forGetter(Quality::level), (App)FoodProperties.PossibleEffect.CODEC.listOf().optionalFieldOf("effects").forGetter(Quality::effects)).apply((Applicative)builder, Quality::new));

    public Holder<QualityType> getType() {
        if (this == NONE) {
            return Holder.direct((Object)QualityType.NONE);
        }
        HolderLookup.RegistryLookup lookup = CommonHooks.resolveLookup(QFComponents.QUALITY_TYPE_REGISTRY);
        if (lookup == null) {
            return Holder.direct((Object)QualityType.NONE);
        }
        Optional optional = lookup.get(QFComponents.key(this.type));
        if (optional.isPresent()) {
            return (Holder)optional.get();
        }
        return Holder.direct((Object)QualityType.NONE);
    }

    public static Quality getRandom(ItemStack stack, int level) {
        HolderLookup.RegistryLookup lookup = CommonHooks.resolveLookup(QFComponents.QUALITY_TYPE_REGISTRY);
        if (lookup == null) {
            return NONE;
        }
        ArrayList<Holder.Reference> types = new ArrayList<Holder.Reference>();
        for (Holder.Reference type : lookup.listElements().toList()) {
            if (((QualityType)type.value()).level() != level) continue;
            types.add(type);
        }
        if (types.isEmpty()) {
            return NONE;
        }
        Collections.shuffle(types);
        return QualityType.createQuality((Holder<QualityType>)((Holder)types.getFirst()), stack);
    }
}

