/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.core.attachments;

import com.mojang.serialization.DynamicOps;
import de.cadentem.quality_food.QualityFood;
import de.cadentem.quality_food.core.attachments.AttachmentHandler;
import de.cadentem.quality_food.core.codecs.Quality;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class LevelData
implements INBTSerializable<CompoundTag> {
    private final HashMap<Long, Quality> qualities = new HashMap();
    @Nullable
    private Quality lastRemoved;

    @NotNull
    public Quality get(BlockPos position) {
        Quality quality = this.qualities.get(position.asLong());
        if (quality == null) {
            return Quality.NONE;
        }
        return quality;
    }

    public void set(BlockPos position, Quality quality) {
        if (quality == Quality.NONE) {
            this.remove(position);
            return;
        }
        this.qualities.put(position.asLong(), quality);
    }

    public void remove(BlockPos position) {
        this.lastRemoved = this.qualities.remove(position.asLong());
    }

    @NotNull
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        for (Long key : this.qualities.keySet()) {
            Optional qualityTag = Quality.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.qualities.get(key)).resultOrPartial(arg_0 -> ((Logger)QualityFood.LOG).error(arg_0));
            qualityTag.ifPresent(value -> tag.put(String.valueOf(key), value));
        }
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.qualities.clear();
        tag.getAllKeys().forEach(key -> {
            Quality quality = Quality.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound(key)).resultOrPartial(arg_0 -> ((Logger)QualityFood.LOG).error(arg_0)).orElse(Quality.NONE);
            this.qualities.put(Long.parseLong(key), quality);
        });
    }

    public static void set(LevelAccessor level, BlockPos position, Quality quality) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (quality != Quality.NONE) {
                LevelData data = (LevelData)serverLevel.getData(AttachmentHandler.LEVEL_DATA);
                data.set(position, quality);
            }
        }
    }

    @NotNull
    public static Quality get(LevelAccessor level, BlockPos position, boolean queryLastRemoved) {
        Quality result = Quality.NONE;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LevelData data = (LevelData)serverLevel.getData(AttachmentHandler.LEVEL_DATA);
            result = data.get(position);
            if (queryLastRemoved && data.lastRemoved != null && result == Quality.NONE) {
                result = data.lastRemoved;
                data.lastRemoved = null;
            }
        }
        return result;
    }

    @NotNull
    public static Quality get(LevelAccessor level, BlockPos position) {
        return LevelData.get(level, position, false);
    }
}

