/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.core.attachments;

import de.cadentem.quality_food.core.Bonus;
import de.cadentem.quality_food.core.codecs.QualityType;
import de.cadentem.quality_food.registry.QFComponents;
import de.cadentem.quality_food.util.QualityUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class BlockData
implements INBTSerializable<CompoundTag> {
    private final Set<Holder<QualityType>> cookedQualities = new HashSet<Holder<QualityType>>();
    private double qualityBonus;

    public void useQuality(ItemStack stack, @Nullable Player player) {
        Holder<QualityType> chosenType = null;
        for (Holder<QualityType> type : this.cookedQualities) {
            if (chosenType != null && ((QualityType)type.value()).level() >= ((QualityType)chosenType.value()).level()) continue;
            chosenType = type;
        }
        if (chosenType != null) {
            QualityUtils.applyQuality(stack, chosenType);
        }
        QualityUtils.applyQuality(stack, (Entity)player, List.of(Bonus.additive((float)this.qualityBonus)), true);
        this.qualityBonus = 0.0;
        this.cookedQualities.clear();
    }

    public double getQuality() {
        return this.qualityBonus;
    }

    public void incrementQuality(double value) {
        this.qualityBonus += value;
    }

    public void addQualityType(Holder<QualityType> type) {
        this.cookedQualities.add(type);
    }

    @NotNull
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putDouble("quality_bonus", this.qualityBonus);
        CompoundTag types = new CompoundTag();
        for (Holder<QualityType> type : this.cookedQualities) {
            Optional optional = type.unwrapKey();
            optional.ifPresent(qualityTypeResourceKey -> types.putBoolean(qualityTypeResourceKey.location().toString(), true));
        }
        tag.put("types", (Tag)types);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.qualityBonus = tag.getDouble("quality_bonus");
        this.cookedQualities.clear();
        CompoundTag types = tag.getCompound("types");
        for (String location : types.getAllKeys()) {
            Optional optional = provider.lookupOrThrow(QFComponents.QUALITY_TYPE_REGISTRY).get(ResourceKey.create(QFComponents.QUALITY_TYPE_REGISTRY, (ResourceLocation)ResourceLocation.parse((String)location)));
            optional.ifPresent(this.cookedQualities::add);
        }
    }
}

