/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.config;

import java.util.function.BiPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class FarmlandConfig {
    public static final int INDEX = 0;
    public static final int CROP = 1;
    public static final int FARMLAND = 2;
    public static final int MULTIPLIER = 3;
    public final BiPredicate<BlockState, BlockState> predicate;
    public final double multiplier;
    public final int index;

    public FarmlandConfig(String config) {
        String[] data = config.split(";");
        this.index = Integer.parseInt(data[0]);
        if (data[1].startsWith("#")) {
            TagKey testCrop = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)data[1].substring(1)));
            if (data[2].startsWith("#")) {
                TagKey testFarmland = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)data[2].substring(1)));
                this.predicate = (crop, farmland) -> crop.is(testCrop) && farmland.is(testFarmland);
            } else {
                Block testFarmland = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)data[2]));
                this.predicate = (crop, farmland) -> crop.is(testCrop) && farmland.getBlock() == testFarmland;
            }
        } else {
            Block testCrop = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)data[1]));
            if (data[2].startsWith("#")) {
                TagKey testFarmland = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.tryParse((String)data[2].substring(1)));
                this.predicate = (crop, farmland) -> crop.getBlock() == testCrop && farmland.is(testFarmland);
            } else {
                Block testFarmland = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)data[2]));
                this.predicate = (crop, farmland) -> crop.getBlock() == testCrop && farmland.getBlock() == testFarmland;
            }
        }
        this.multiplier = Double.parseDouble(data[3]);
    }
}

