/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.compat.jade;

import de.cadentem.quality_food.QualityFood;
import de.cadentem.quality_food.core.attachments.AttachmentHandler;
import de.cadentem.quality_food.core.attachments.LevelData;
import de.cadentem.quality_food.core.codecs.Quality;
import de.cadentem.quality_food.core.codecs.QualityType;
import de.cadentem.quality_food.registry.QFComponents;
import de.cadentem.quality_food.util.Utils;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.impl.ui.ElementHelper;

public class QualityProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    private static final ResourceLocation ID = QualityFood.location("quality");
    private static final Vec2 TRANSLATE = new Vec2(2.0f, 0.5f);

    public void appendTooltip(ITooltip toolTip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag tag = accessor.getServerData();
        if (tag.contains(QualityFood.concat("type"))) {
            int level = tag.getInt(QualityFood.concat("level"));
            if (level <= 0) {
                return;
            }
            ResourceLocation location = ResourceLocation.parse((String)tag.getString(QualityFood.concat("type")));
            toolTip.add((Component)Component.translatable((String)QualityFood.concat("quality")));
            toolTip.append((Component)Component.translatable((String)("quality_type." + location.toLanguageKey())));
            Optional optional = accessor.getLevel().holder(ResourceKey.create(QFComponents.QUALITY_TYPE_REGISTRY, (ResourceLocation)location));
            optional.ifPresent(qualityTypeReference -> toolTip.append(ElementHelper.INSTANCE.sprite(((QualityType)qualityTypeReference.value()).icon(), 10, 10).translate(TRANSLATE)));
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        Quality quality = ((LevelData)accessor.getLevel().getData(AttachmentHandler.LEVEL_DATA)).get(accessor.getPosition());
        if (quality != Quality.NONE) {
            tag.putString(QualityFood.concat("type"), quality.type().toString());
            tag.putInt(QualityFood.concat("level"), quality.level());
        }
    }

    public boolean shouldRequestData(BlockAccessor accessor) {
        return Utils.isValidBlock(accessor.getBlock());
    }
}

