/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.client;

import de.cadentem.quality_food.core.EffectComponent;
import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class ClientEffectComponent
implements ClientTooltipComponent {
    private static final DecimalFormat FORMAT = new DecimalFormat("###.##");
    private static final int ICON_SIZE = 12;
    private final MutableComponent text;
    private final TextureAtlasSprite sprite;

    public ClientEffectComponent(EffectComponent component) {
        MobEffectInstance instance = component.possibleEffect().effect();
        MutableComponent effectTooltip = Component.translatable((String)instance.getDescriptionId());
        if (instance.getAmplifier() > 0) {
            effectTooltip = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{effectTooltip, Component.translatable((String)("potion.potency." + instance.getAmplifier()))});
        }
        if (instance.getDuration() > 20) {
            ClientLevel level = Minecraft.getInstance().level;
            float tickRate = level != null ? level.tickRateManager().tickrate() : 20.0f;
            effectTooltip = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{effectTooltip, MobEffectUtil.formatDuration((MobEffectInstance)instance, (float)1.0f, (float)tickRate)});
        }
        ChatFormatting formatting = ((MobEffect)instance.getEffect().value()).getCategory().getTooltipFormatting();
        this.text = Component.translatable((String)"potion.withProbability", (Object[])new Object[]{effectTooltip, FORMAT.format(component.possibleEffect().probability() * 100.0f) + "%"}).withStyle(formatting);
        this.sprite = Minecraft.getInstance().getMobEffectTextures().get(instance.getEffect());
    }

    public int getHeight() {
        return 12;
    }

    public int getWidth(@NotNull Font font) {
        return font.width((FormattedText)this.text) + 12;
    }

    public void renderImage(@NotNull Font font, int x, int y, @NotNull GuiGraphics graphics) {
        graphics.blit(x, y, 0, 9, 9, this.sprite);
    }

    public void renderText(@NotNull Font font, int mouseX, int mouseY, @NotNull Matrix4f matrix, @NotNull MultiBufferSource.BufferSource bufferSource) {
        font.drawInBatch((Component)this.text, (float)(mouseX + 12), (float)(mouseY + 1), -1, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }
}

