/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food;

import com.mojang.logging.LogUtils;
import de.cadentem.quality_food.compat.Compat;
import de.cadentem.quality_food.config.ServerConfig;
import de.cadentem.quality_food.core.attachments.AttachmentHandler;
import de.cadentem.quality_food.events.ModEvents;
import de.cadentem.quality_food.registry.QFCommands;
import de.cadentem.quality_food.registry.QFComponents;
import de.cadentem.quality_food.registry.QFLootModifiers;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;

@Mod(value="quality_food")
public class QualityFood {
    public static final String MODID = "quality_food";
    public static final Logger LOG = LogUtils.getLogger();

    public QualityFood(IEventBus bus, ModContainer container) {
        QFComponents.REGISTRAR.register(bus);
        AttachmentHandler.ATTACHMENT_TYPES.register(bus);
        QFLootModifiers.LOOT_MODIFIERS.register(bus);
        QFCommands.COMMAND_ARGUMENTS.register(bus);
        NeoForge.EVENT_BUS.addListener(QFCommands::registerCommands);
        NeoForge.EVENT_BUS.addListener(ServerConfig::storeServer);
        if (Compat.isModLoaded("harvestwithease")) {
            NeoForge.EVENT_BUS.addListener(ModEvents::handleHarvestEvent);
        }
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC);
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static String concat(String path) {
        return "quality_food." + path;
    }
}

