/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.ListOptionEntry;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.DescriptionWithName;
import dev.isxander.yacl3.gui.LowProfileButtonWidget;
import dev.isxander.yacl3.gui.TextScaledButtonWidget;
import dev.isxander.yacl3.gui.TooltipButtonWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.YACLSelectionList;
import dev.isxander.yacl3.gui.utils.WidgetUtils;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionListWidget
extends YACLSelectionList<Entry> {
    private final YACLScreen yaclScreen;
    private final ConfigCategory category;
    private String searchQuery = "";
    private final Consumer<DescriptionWithName> hoverEvent;
    private DescriptionWithName lastHoveredOption;

    public OptionListWidget(YACLScreen screen, ConfigCategory category, Minecraft client, int x, int y, int width, int height, Consumer<DescriptionWithName> hoverEvent) {
        super(client, width, height, y);
        this.yaclScreen = screen;
        this.category = category;
        this.hoverEvent = hoverEvent;
        this.refreshOptions();
        for (OptionGroup group : category.groups()) {
            if (!(group instanceof ListOption)) continue;
            ListOption listOption = (ListOption)group;
            listOption.addRefreshListener(() -> this.refreshListEntries(listOption, category));
        }
    }

    public void refreshOptions() {
        this.clearEntries();
        for (OptionGroup group : this.category.groups()) {
            GroupSeparatorEntry groupSeparatorEntry;
            if (!group.isRoot()) {
                GroupSeparatorEntry groupSeparatorEntry2;
                if (group instanceof ListOption) {
                    ListOption listOption = (ListOption)group;
                    groupSeparatorEntry2 = new ListGroupSeparatorEntry(this, listOption, this.yaclScreen);
                } else {
                    groupSeparatorEntry2 = new GroupSeparatorEntry(group, this.yaclScreen);
                }
                groupSeparatorEntry = groupSeparatorEntry2;
                this.addEntry((AbstractSelectionList.Entry)groupSeparatorEntry);
            } else {
                groupSeparatorEntry = null;
            }
            ArrayList<Entry> optionEntries = new ArrayList<Entry>();
            if (groupSeparatorEntry instanceof ListGroupSeparatorEntry) {
                ListGroupSeparatorEntry listGroupSeparatorEntry = (ListGroupSeparatorEntry)groupSeparatorEntry;
                if (listGroupSeparatorEntry.listOption.options().isEmpty()) {
                    EmptyListLabel emptyListLabel = new EmptyListLabel(this, listGroupSeparatorEntry, this.category);
                    this.addEntry((AbstractSelectionList.Entry)emptyListLabel);
                    optionEntries.add(emptyListLabel);
                }
            }
            for (Option option : group.options()) {
                OptionEntry entry = new OptionEntry(option, this.category, group, groupSeparatorEntry, option.controller().provideWidget(this.yaclScreen, this.getDefaultEntryDimension()));
                this.addEntry((AbstractSelectionList.Entry)entry);
                optionEntries.add(entry);
            }
            if (groupSeparatorEntry == null) continue;
            groupSeparatorEntry.setChildEntries(optionEntries);
        }
        this.setScrollAmount(0.0);
        this.repositionEntries();
    }

    private void refreshListEntries(ListOption<?> listOption, ConfigCategory category) {
        ListGroupSeparatorEntry groupSeparator = this.children().stream().filter(e -> {
            if (!(e instanceof ListGroupSeparatorEntry)) return false;
            ListGroupSeparatorEntry gs = (ListGroupSeparatorEntry)((Object)e);
            if (gs.group != listOption) return false;
            return true;
        }).map(ListGroupSeparatorEntry.class::cast).findAny().orElse(null);
        if (groupSeparator == null) {
            YACLConstants.LOGGER.warn("Can't find group seperator to refresh list option entries for list option " + String.valueOf(listOption.name()));
            return;
        }
        for (Entry entry : groupSeparator.childEntries) {
            this.removeEntry((AbstractSelectionList.Entry)entry);
        }
        groupSeparator.childEntries.clear();
        if (listOption.options().isEmpty()) {
            EmptyListLabel emptyListLabel = new EmptyListLabel(this, groupSeparator, category);
            this.addEntryBelow(groupSeparator, emptyListLabel);
            groupSeparator.childEntries.add(emptyListLabel);
            return;
        }
        Entry lastEntry = groupSeparator;
        for (ListOptionEntry listOptionEntry : listOption.options()) {
            OptionEntry optionEntry = new OptionEntry(listOptionEntry, category, listOption, groupSeparator, listOptionEntry.controller().provideWidget(this.yaclScreen, this.getDefaultEntryDimension()));
            this.addEntryBelow(lastEntry, optionEntry);
            groupSeparator.childEntries.add(optionEntry);
            lastEntry = optionEntry;
        }
    }

    public Dimension<Integer> getDefaultEntryDimension() {
        return Dimension.ofInt(this.getRowLeft(), 0, this.getRowWidth(), 20);
    }

    public void expandAllGroups() {
        for (Entry entry : super.children()) {
            if (!(entry instanceof GroupSeparatorEntry)) continue;
            GroupSeparatorEntry groupSeparatorEntry = (GroupSeparatorEntry)entry;
            groupSeparatorEntry.setExpanded(true);
        }
    }

    public int getRowLeft() {
        return super.getRowLeft() - 6;
    }

    public int getRowWidth() {
        return this.getWidth() - 6 - 20;
    }

    public void updateSearchQuery(String query) {
        this.searchQuery = query;
        for (Entry entry : this.children()) {
            entry.updateSearchQuery(query);
        }
        this.expandAllGroups();
        this.repositionEntries();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (Entry child : this.children()) {
            if (child == this.getEntryAtPosition(mouseX, mouseY) || !(child instanceof OptionEntry)) continue;
            OptionEntry optionEntry = (OptionEntry)child;
            optionEntry.widget.unfocus();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double horizontal, double vertical) {
        Entry child;
        super.mouseScrolled(mouseX, mouseY, horizontal, vertical);
        Iterator iterator = this.children().iterator();
        while (iterator.hasNext() && !(child = (Entry)((Object)iterator.next())).mouseScrolled(mouseX, mouseY, horizontal, vertical)) {
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.getFocused() != null && this.isDragging() && this.isValidMouseClick(button)) {
            return WidgetUtils.mouseDragged((GuiEventListener)this.getFocused(), mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (Entry child : this.children()) {
            if (!child.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char chr, int modifiers) {
        for (Entry child : this.children()) {
            if (!child.charTyped(chr, modifiers)) continue;
            return true;
        }
        return super.charTyped(chr, modifiers);
    }

    private List<Entry> superModifiableChildren() {
        return this.children();
    }

    public void addEntryAtIndex(int index, Entry entry) {
        this.superModifiableChildren().add(index, entry);
        this.repositionEntries();
    }

    public void addEntryBelow(Entry below, Entry entry) {
        int idx = this.superModifiableChildren().indexOf((Object)below) + 1;
        if (idx == 0) {
            throw new IllegalStateException("The entry to insert below does not exist!");
        }
        this.addEntryAtIndex(idx, entry);
    }

    public void addEntryBelowWithoutScroll(Entry below, Entry entry) {
        double d = (double)this.contentHeight() - this.scrollAmount();
        this.addEntryBelow(below, entry);
        this.setScrollAmount((double)this.contentHeight() - d);
    }

    private void setHoverDescription(DescriptionWithName description) {
        if (description != this.lastHoveredOption) {
            this.lastHoveredOption = description;
            this.hoverEvent.accept(description);
        }
    }

    protected void renderListBackground(GuiGraphics guiGraphics) {
    }

    protected boolean isValidMouseClick(int button) {
        return button == 0 || button == 1 || button == 2;
    }

    protected Entry nextEntry(@NotNull ScreenDirection direction, @NotNull Predicate<Entry> predicate, Entry selected) {
        return (Entry)super.nextEntry(direction, entry -> entry.isViewable() && predicate.test((Entry)((Object)entry)), (AbstractSelectionList.Entry)selected);
    }

    public class ListGroupSeparatorEntry
    extends GroupSeparatorEntry {
        private final ListOption<?> listOption;
        private final TextScaledButtonWidget resetListButton;
        private final TooltipButtonWidget addListButton;

        private ListGroupSeparatorEntry(OptionListWidget this$0, ListOption<?> group, Screen screen) {
            super(group, screen);
            this.listOption = group;
            this.resetListButton = new TextScaledButtonWidget(screen, this$0.getRowRight() - 20, -50, 20, 20, 1.0f, (Component)Component.literal((String)"\u21bb"), button -> group.requestSetDefault());
            group.addListener((opt, val) -> {
                this.resetListButton.active = !opt.isPendingValueDefault() && opt.available();
            });
            this.resetListButton.active = !group.isPendingValueDefault() && group.available();
            this.addListButton = new TooltipButtonWidget(this$0.yaclScreen, this.resetListButton.getX() - 20, -50, 20, 20, (Component)Component.literal((String)"+"), (Component)Component.translatable((String)"yacl.list.add_top"), btn -> {
                group.insertNewEntry();
                this.setExpanded(true);
            });
            this.updateExpandMinimizeText();
            this.minimizeIfUnavailable();
        }

        @Override
        public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            if (!this.isViewable()) {
                return;
            }
            this.updateExpandMinimizeText();
            super.renderContent(graphics, mouseX, mouseY, hovered, deltaTicks);
            int buttonY = this.expandMinimizeButton.getY();
            this.resetListButton.setY(buttonY);
            this.addListButton.setY(buttonY);
            this.resetListButton.render(graphics, mouseX, mouseY, deltaTicks);
            this.addListButton.render(graphics, mouseX, mouseY, deltaTicks);
        }

        private void minimizeIfUnavailable() {
            if (!this.listOption.available() && this.isExpanded()) {
                this.setExpanded(false);
            }
        }

        @Override
        protected void updateExpandMinimizeText() {
            super.updateExpandMinimizeText();
            boolean bl = this.expandMinimizeButton.active = this.listOption == null || this.listOption.available();
            if (this.addListButton != null) {
                this.addListButton.active = this.expandMinimizeButton.active && this.listOption.numberOfEntries() < this.listOption.maximumNumberOfEntries();
            }
        }

        @Override
        public void setExpanded(boolean expanded) {
            super.setExpanded(this.listOption.available() && expanded);
        }

        @Override
        @NotNull
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)((Object)this.expandMinimizeButton), (Object)((Object)this.addListButton), (Object)((Object)this.resetListButton));
        }
    }

    public class GroupSeparatorEntry
    extends Entry {
        protected final OptionGroup group;
        protected final MultiLineLabel wrappedName;
        protected final MultiLineLabel wrappedTooltip;
        protected final LowProfileButtonWidget expandMinimizeButton;
        protected final Screen screen;
        protected final Font font;
        protected boolean groupExpanded;
        protected List<Entry> childEntries;

        private GroupSeparatorEntry(OptionGroup group, Screen screen) {
            super(OptionListWidget.this);
            this.font = Minecraft.getInstance().font;
            this.childEntries = new ArrayList<Entry>();
            this.group = group;
            this.screen = screen;
            this.wrappedName = MultiLineLabel.create((Font)this.font, (Component)group.name(), (int)(OptionListWidget.this.getRowWidth() - 45));
            this.wrappedTooltip = MultiLineLabel.create((Font)this.font, (Component)group.tooltip(), (int)(screen.width / 3 * 2 - 10));
            this.groupExpanded = !group.collapsed();
            this.expandMinimizeButton = new LowProfileButtonWidget(0, 0, 20, 20, (Component)Component.empty(), btn -> this.onExpandButtonPress());
            this.updateExpandMinimizeText();
            this.updateHeight();
        }

        @Override
        public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            if (!this.isViewable()) {
                return;
            }
            this.updateHeight();
            int buttonY = this.getY() + this.getHeight() / 2 - this.expandMinimizeButton.getHeight() / 2 + 1;
            this.expandMinimizeButton.setY(buttonY);
            this.expandMinimizeButton.setX(this.getX());
            this.expandMinimizeButton.render(graphics, mouseX, mouseY, deltaTicks);
            this.wrappedName.renderCentered(graphics, this.getX() + this.getWidth() / 2, this.getY() + this.getYPadding());
            if (this.isMouseOver(mouseX, mouseY)) {
                OptionListWidget.this.setHoverDescription(DescriptionWithName.of(this.group.name(), this.group.description()));
            }
        }

        public boolean isExpanded() {
            return this.groupExpanded;
        }

        public void setExpanded(boolean expanded) {
            if (this.groupExpanded == expanded) {
                return;
            }
            this.groupExpanded = expanded;
            this.updateExpandMinimizeText();
            this.childEntries.forEach(Entry::refreshVisibilityState);
            OptionListWidget.this.repositionEntries();
        }

        protected void onExpandButtonPress() {
            this.setExpanded(!this.isExpanded());
        }

        protected void updateExpandMinimizeText() {
            this.expandMinimizeButton.setMessage((Component)Component.literal((String)(this.isExpanded() ? "\u25bc" : "\u25b6")));
        }

        public void setChildEntries(List<? extends Entry> childEntries) {
            this.childEntries.clear();
            this.childEntries.addAll(childEntries);
        }

        @Override
        public boolean updateSearchQuery(String searchQuery) {
            this.searchQueryMatches = searchQuery.isEmpty() || this.childEntries.stream().anyMatch(e -> e.updateSearchQuery(searchQuery));
            return this.searchQueryMatches;
        }

        private int getYPadding() {
            return 6;
        }

        public void setFocused(boolean focused) {
            super.setFocused(focused);
            if (focused) {
                OptionListWidget.this.setHoverDescription(DescriptionWithName.of(this.group.name(), this.group.description()));
            }
        }

        private void updateHeight() {
            int n = Math.max(this.wrappedName.getLineCount(), 1);
            Objects.requireNonNull(this.font);
            this.setHeight(n * 9 + this.getYPadding() * 2);
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                @NotNull
                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(NarrationElementOutput builder) {
                    builder.add(NarratedElementType.TITLE, GroupSeparatorEntry.this.group.name());
                    builder.add(NarratedElementType.HINT, GroupSeparatorEntry.this.group.tooltip());
                }
            });
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)((Object)this.expandMinimizeButton));
        }
    }

    public class EmptyListLabel
    extends Entry {
        private final ListGroupSeparatorEntry parent;
        private final String groupName;
        private final String categoryName;

        public EmptyListLabel(OptionListWidget this$0, ListGroupSeparatorEntry parent, ConfigCategory category) {
            super(this$0);
            this.parent = parent;
            this.groupName = parent.group.name().getString().toLowerCase();
            this.categoryName = category.name().getString().toLowerCase();
            this.setHeight(11);
        }

        @Override
        public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            graphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"yacl.list.empty").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}), this.getX() + this.getWidth() / 2, this.getY(), -1);
        }

        @Override
        public boolean updateSearchQuery(String searchQuery) {
            this.searchQueryMatches = searchQuery.isEmpty() || this.groupName.contains(searchQuery);
            return this.searchQueryMatches;
        }

        @Override
        public boolean isViewable() {
            return this.parent.isExpanded() && super.isViewable();
        }

        @Override
        protected void onBecameHidden() {
            super.onBecameHidden();
            this.setHeight(0);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of();
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of();
        }
    }

    public class OptionEntry
    extends Entry {
        public final Option<?> option;
        public final ConfigCategory category;
        public final OptionGroup group;
        @Nullable
        public final GroupSeparatorEntry groupSeparatorEntry;
        public final AbstractWidget widget;
        private final TextScaledButtonWidget resetButton;
        private final String categoryName;
        private final String groupName;

        public OptionEntry(Option<?> option, ConfigCategory category, @Nullable OptionGroup group, GroupSeparatorEntry groupSeparatorEntry, AbstractWidget widget) {
            super(OptionListWidget.this);
            this.option = option;
            this.category = category;
            this.group = group;
            this.groupSeparatorEntry = groupSeparatorEntry;
            this.widget = widget;
            this.categoryName = category.name().getString().toLowerCase();
            this.groupName = group.name().getString().toLowerCase();
            if (option.canResetToDefault() && this.widget.canReset()) {
                this.widget.setDimension(this.widget.getDimension().expanded(-20, 0));
                this.resetButton = new TextScaledButtonWidget((Screen)OptionListWidget.this.yaclScreen, (int)widget.getDimension().xLimit(), -50, 20, 20, 2.0f, (Component)Component.literal((String)"\u21bb"), button -> option.requestSetDefault());
                option.addListener((opt, val) -> {
                    this.resetButton.active = !opt.isPendingValueDefault() && opt.available();
                });
                this.resetButton.active = !option.isPendingValueDefault() && option.available();
            } else {
                this.resetButton = null;
            }
            this.updateHeight();
        }

        @Override
        public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            if (!this.isViewable()) {
                return;
            }
            this.updateHeight();
            this.widget.setDimension(this.widget.getDimension().withY(this.getY()));
            this.widget.render(graphics, mouseX, mouseY, deltaTicks);
            if (this.resetButton != null) {
                this.resetButton.setY(this.getY());
                this.resetButton.render(graphics, mouseX, mouseY, deltaTicks);
            }
            if (this.isMouseOver(mouseX, mouseY)) {
                OptionListWidget.this.setHoverDescription(DescriptionWithName.of(this.option.name(), this.option.description()));
            }
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double horizontal, double vertical) {
            return this.widget.mouseScrolled(mouseX, mouseY, horizontal, vertical);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            return WidgetUtils.keyPressed(this.widget, keyCode, scanCode, modifiers);
        }

        public boolean charTyped(char chr, int modifiers) {
            return WidgetUtils.charTyped(this.widget, chr, modifiers);
        }

        @Override
        public boolean updateSearchQuery(String searchQuery) {
            this.searchQueryMatches = searchQuery.isEmpty() || this.groupName.contains(searchQuery) || this.widget.matchesSearch(searchQuery);
            this.refreshVisibilityState();
            return this.searchQueryMatches;
        }

        @Override
        public boolean isViewable() {
            return super.isViewable() && (this.groupSeparatorEntry == null || this.groupSeparatorEntry.isExpanded());
        }

        @Override
        protected void onBecameViewable() {
            super.onBecameViewable();
            this.updateHeight();
        }

        private void updateHeight() {
            this.setHeight(Math.max(this.widget.getDimension().height(), this.resetButton != null ? this.resetButton.getHeight() : 0) + 2);
        }

        public void setFocused(boolean focused) {
            super.setFocused(focused);
            if (focused) {
                OptionListWidget.this.setHoverDescription(DescriptionWithName.of(this.option.name(), this.option.description()));
            }
        }

        public List<? extends NarratableEntry> narratables() {
            if (this.resetButton == null) {
                return ImmutableList.of((Object)this.widget);
            }
            return ImmutableList.of((Object)this.widget, (Object)((Object)this.resetButton));
        }

        public List<? extends GuiEventListener> children() {
            if (this.resetButton == null) {
                return ImmutableList.of((Object)this.widget);
            }
            return ImmutableList.of((Object)this.widget, (Object)((Object)this.resetButton));
        }
    }

    public abstract class Entry
    extends YACLSelectionList.Entry<Entry> {
        protected boolean searchQueryMatches = true;

        public Entry(OptionListWidget this$0) {
            super(this$0);
        }

        public boolean updateSearchQuery(String searchQuery) {
            boolean matches = searchQuery.isEmpty();
            if (this.searchQueryMatches != matches) {
                this.searchQueryMatches = matches;
                this.refreshVisibilityState();
            }
            return this.searchQueryMatches;
        }

        public boolean isViewable() {
            return this.searchQueryMatches;
        }

        @Override
        public int getHeight() {
            if (!this.isViewable()) {
                return 0;
            }
            return super.getHeight();
        }

        protected void refreshVisibilityState() {
            if (this.isViewable()) {
                this.onBecameViewable();
            } else {
                this.onBecameHidden();
            }
        }

        protected void onBecameViewable() {
        }

        protected void onBecameHidden() {
            this.setHeight(0);
        }
    }
}

