/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import com.google.common.io.Files;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import journeymap.client.io.FileHandler;
import journeymap.common.Journeymap;
import journeymap.common.codecs.WaypointCodecs;
import journeymap.common.codecs.WaypointGroupCodecs;
import journeymap.common.nbt.waypoint.WaypointDAO;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointImpl;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;

public class ClientWaypointDAO
extends WaypointDAO {
    protected static final String DAT_FILE = "WaypointData.dat";
    private final ReentrantLock writeLock = new ReentrantLock();

    public ClientWaypointDAO() {
        this.data = this.load(true);
    }

    @Override
    public Map<String, WaypointGroupImpl> decodeGroups(CompoundTag data) {
        LinkedHashMap<String, WaypointGroupImpl> groups = new LinkedHashMap<String, WaypointGroupImpl>();
        if (data.contains("groups")) {
            CompoundTag groupsTags = data.getCompound("groups");
            for (String key : groupsTags.getAllKeys()) {
                Tag tag = groupsTags.get(key);
                DataResult result = WaypointGroupCodecs.V1_WAYPOINT_GROUP_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag);
                if (!result.result().isPresent()) continue;
                WaypointGroupImpl group = (WaypointGroupImpl)result.result().get();
                groups.put(group.getGuid(), group);
            }
        }
        return groups;
    }

    @Override
    public CompoundTag encodeGroups(Collection<WaypointGroupImpl> groups) {
        CompoundTag tag = new CompoundTag();
        tag.put("groups", (Tag)new CompoundTag());
        CompoundTag groupsTag = tag.getCompound("groups");
        for (WaypointGroupImpl group : groups) {
            DataResult result = WaypointGroupCodecs.V1_WAYPOINT_GROUP_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)group);
            if (!result.result().isPresent()) continue;
            groupsTag.put(group.getGuid(), (Tag)result.result().get());
        }
        return tag;
    }

    @Override
    public Map<String, WaypointImpl> decodeWaypoints(CompoundTag data) {
        LinkedHashMap<String, WaypointImpl> waypoints = new LinkedHashMap<String, WaypointImpl>();
        if (data.contains("waypoints")) {
            CompoundTag groupsTags = data.getCompound("waypoints");
            for (String key : groupsTags.getAllKeys()) {
                Tag tag = groupsTags.get(key);
                WaypointImpl waypoint = this.decodeWaypoint(tag);
                if (waypoint == null) continue;
                waypoints.put(waypoint.getGuid(), waypoint);
            }
        }
        return waypoints;
    }

    @Override
    public CompoundTag encodeWaypoints(Collection<WaypointImpl> waypoints) {
        CompoundTag tag = new CompoundTag();
        tag.put("waypoints", (Tag)new CompoundTag());
        CompoundTag wpTag = tag.getCompound("waypoints");
        for (WaypointImpl wp : waypoints) {
            Tag result = this.encodeWaypoint(wp);
            if (result == null) continue;
            wpTag.put(wp.getGuid(), result);
        }
        return tag;
    }

    @Override
    public WaypointImpl decodeWaypoint(Tag data) {
        DataResult result = WaypointCodecs.V1_WAYPOINT_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)data);
        if (result.result().isPresent()) {
            return (WaypointImpl)result.result().get();
        }
        return null;
    }

    @Override
    public Tag encodeWaypoint(WaypointImpl waypoint) {
        DataResult result = WaypointCodecs.V1_WAYPOINT_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)waypoint);
        if (result.result().isPresent()) {
            return (Tag)result.result().get();
        }
        return null;
    }

    @Override
    public WaypointImpl copyWaypoint(WaypointImpl waypoint) {
        Tag rawCopy = this.encodeWaypoint(waypoint);
        if (rawCopy != null) {
            return this.decodeWaypoint(rawCopy);
        }
        return null;
    }

    private File getFile() {
        return new File(FileHandler.getWaypointDir(), DAT_FILE);
    }

    private void write(File path) {
        this.writeLock.lock();
        try (FileOutputStream fos = new FileOutputStream(path);
             DataOutputStream outputStream = new DataOutputStream(fos);){
            NbtIo.write((CompoundTag)this.data, (DataOutput)outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void save(boolean async) {
        if (this.isDirty()) {
            this.write(this.getFile());
            this.setDirty(false);
        }
    }

    @Override
    public Map<String, WaypointGroupImpl> getGroups() {
        return this.decodeGroups(this.data);
    }

    @Override
    public Map<String, WaypointImpl> getWaypoints() {
        return this.decodeWaypoints(this.data);
    }

    private CompoundTag load(boolean backup) {
        try {
            if (this.getFile().exists()) {
                CompoundTag data = NbtIo.read((Path)this.getFile().toPath());
                if (backup) {
                    ClientWaypointDAO.backup(new File(FileHandler.getWaypointDir(), "backup"), this.getFile());
                }
                return data;
            }
            return new CompoundTag();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("WaypointData.dat file is corrupted. Deleting as it is unusable.", (Throwable)e);
            if (this.getFile().exists()) {
                File corrupted = new File(FileHandler.getWaypointDir(), "corrupted");
                ClientWaypointDAO.backup(corrupted, this.getFile());
                this.getFile().delete();
            }
            if (ClientWaypointDAO.restore(new File(FileHandler.getWaypointDir(), "backup"), FileHandler.getWaypointDir(), DAT_FILE)) {
                return this.load(false);
            }
            return new CompoundTag();
        }
    }

    private static boolean restore(File backupDir, File dir, String fileName) {
        File backupFile = new File(backupDir, fileName);
        Journeymap.getLogger().error("Corrupted waypoint dat file detected, restoring backup from {}", (Object)backupFile);
        try {
            if (!backupFile.exists()) {
                return false;
            }
            File file = new File(dir, backupFile.getName());
            Files.copy((File)backupFile, (File)file);
            return true;
        }
        catch (Exception e) {
            Journeymap.getLogger().error(String.format("Can't restore file %s: %s", backupFile, e));
            return false;
        }
    }

    private static void backup(File backupDir, File oldFile) {
        try {
            if (!backupDir.exists()) {
                backupDir.mkdirs();
            }
            File file = new File(backupDir, oldFile.getName());
            Files.copy((File)oldFile, (File)file);
        }
        catch (Exception e) {
            Journeymap.getLogger().error(String.format("Can't backup file %s: %s", oldFile, e));
        }
    }
}

