/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io.nbt;

import com.mojang.datafixers.DataFixer;
import java.util.Optional;
import journeymap.client.io.nbt.CustomChunkReader;
import journeymap.client.io.nbt.RegionLoader;
import journeymap.client.model.chunk.ChunkMD;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import org.apache.logging.log4j.Logger;

public class JMChunkLoader {
    private static Logger logger = Journeymap.getLogger();

    public static ChunkMD getChunkMD(ChunkStorage loader, Minecraft mc, ChunkPos coord, boolean forceRetain) {
        if (RegionLoader.getRegionFile(mc, coord.x, coord.z).exists()) {
            return JMChunkLoader.getChunkFromRegion(mc.level, coord, loader, forceRetain);
        }
        logger.warn("Region doesn't exist for chunk: " + String.valueOf(coord));
        return null;
    }

    private static ChunkMD getChunkFromRegion(ClientLevel world, ChunkPos coord, ChunkStorage loader, boolean forceRetain) {
        try {
            Optional nbt = (Optional)loader.read(coord).get();
            if (nbt.isPresent()) {
                return JMChunkLoader.getChunkFromNBT(world, coord, (CompoundTag)nbt.get(), forceRetain);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ChunkMD getChunkFromNBT(ClientLevel world, ChunkPos coord, CompoundTag nbt, boolean forceRetain) {
        int dataVersion;
        DataFixer fixer = Minecraft.getInstance().getFixerUpper();
        nbt = DataFixTypes.CHUNK.updateToCurrentVersion(fixer, nbt, dataVersion = ChunkStorage.getVersion((CompoundTag)nbt));
        CustomChunkReader.ProcessedChunk processedChunk = CustomChunkReader.read(world, coord, nbt);
        if (processedChunk != null && processedChunk.chunk() != null) {
            return new ChunkMD(processedChunk.chunk(), forceRetain, processedChunk.light());
        }
        return null;
    }

    public static ChunkMD getChunkMdFromMemory(Level level, int chunkX, int chunkZ) {
        LevelChunk theChunk;
        ChunkSource provider;
        if (level != null && level == Minecraft.getInstance().player.getCommandSenderWorld() && (provider = level.getChunkSource()) != null && (theChunk = level.getChunk(chunkX, chunkZ)) != null && !(theChunk instanceof EmptyLevelChunk) && theChunk.getLevel() == Minecraft.getInstance().player.getCommandSenderWorld()) {
            return new ChunkMD(theChunk);
        }
        return null;
    }
}

