/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.compatibility.prettypipes;

import com.heaser.pipeconnector.compatibility.interfaces.IPlacer;
import com.heaser.pipeconnector.utils.GeneralUtils;
import de.ellpeck.prettypipes.items.PipeFrameItem;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PrettyPipesCompatibility
implements IPlacer {
    public static Class<? extends Block> getBlockToRegister() {
        return PipeBlock.class;
    }

    public static Class<? extends Item> getItemStackClassToRegister() {
        return PipeFrameItem.class;
    }

    @Override
    public boolean place(Level level, BlockPos pos, Player player, Item item, List<Direction> side, ItemStack heldPipeItem) {
        if (!GeneralUtils.isVoidableBlock(level, pos)) {
            BlockState state = level.getBlockState(pos);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                List drops = Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)heldPipeItem);
                for (ItemStack drop : drops) {
                    if (player.getInventory().add(drop)) continue;
                    player.drop(drop, false);
                }
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.POOF, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5, 0.1, 0.1, 0.1, 0.05);
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            level.removeBlock(pos, false);
        }
        BlockState blockState = Block.byItem((Item)item).defaultBlockState();
        boolean isWaterBlock = this.isWaterBlock(level, pos);
        boolean hasLevelBlockStateProperty = this.hasLevelBlockStateProperty(level, pos);
        if (isWaterBlock && hasLevelBlockStateProperty && !this.isFlowingWaterBlock(level, pos)) {
            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.TRUE);
        }
        return level.setBlockAndUpdate(pos, blockState);
    }

    public boolean isWaterBlock(Level level, BlockPos pos) {
        return level.getBlockState(pos).getBlock() == Blocks.WATER;
    }

    public boolean hasLevelBlockStateProperty(Level level, BlockPos pos) {
        return level.getBlockState(pos).hasProperty((Property)BlockStateProperties.LEVEL);
    }

    public boolean isFlowingWaterBlock(Level level, BlockPos pos) {
        return (Integer)level.getBlockState(pos).getValue((Property)BlockStateProperties.LEVEL) > 0;
    }
}

