/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.utils;

import dev.latvian.mods.kubejs.stages.Stages;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;

public class StageUtils {
    private static final Map<String, Cache> stageCache = new HashMap<String, Cache>();

    public static Cache get(UUID uuid) {
        String uuidString = uuid.toString();
        if (stageCache.containsKey(uuidString)) {
            return stageCache.get(uuidString);
        }
        return Cache.EMPTY;
    }

    public static void initializePlayer(Player player) {
        Stages stages = player.kjs$getStages();
        String uuidString = player.getUUID().toString();
        if (stageCache.containsKey(uuidString)) {
            stageCache.get(uuidString).invalidate();
        }
        stageCache.put(uuidString, new Cache(new HashSet<String>(stages.getAll())));
    }

    public static class Cache {
        public static final Cache EMPTY = new Cache(Set.of());
        public final Set<String> stages;
        private boolean invalidated = false;

        public Cache(Set<String> stages) {
            this.stages = stages;
        }

        private void invalidate() {
            this.invalidated = true;
        }

        public boolean invalidated() {
            return this.invalidated;
        }

        static {
            EMPTY.invalidate();
        }
    }
}

