/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.powerfuljs.serde;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public record SpeedModifiers(Map<String, SpeedModifier> modifiers) {
    public static final SpeedModifiers EMPTY = new SpeedModifiers(Map.of());
    public static final Codec<SpeedModifiers> CODEC = SpeedModifier.CODEC.listOf().xmap(l -> new SpeedModifiers(l.stream().collect(Collectors.toUnmodifiableMap(modifier -> modifier.id, modifier -> modifier))), m -> m.modifiers.values().stream().toList());

    public float getTickSpeed() {
        float addBase = 0.0f;
        float multiplyBase = 1.0f;
        float addTotal = 0.0f;
        float multiplyTotal = 1.0f;
        for (SpeedModifier modifier : this.modifiers.values()) {
            switch (modifier.operation.ordinal()) {
                case 0: {
                    addBase += modifier.amount;
                    break;
                }
                case 1: {
                    multiplyBase += modifier.amount;
                    break;
                }
                case 2: {
                    addTotal += modifier.amount;
                    break;
                }
                case 3: {
                    multiplyTotal *= 1.0f + modifier.amount;
                }
            }
        }
        return Math.max(0.0f, (1.0f + addBase) * multiplyBase * multiplyTotal + addTotal);
    }

    public SpeedModifiers withModifier(SpeedModifier modifier) {
        HashMap<String, SpeedModifier> newMap = new HashMap<String, SpeedModifier>(this.modifiers);
        newMap.put(modifier.id, modifier);
        return new SpeedModifiers(Map.copyOf(newMap));
    }

    public SpeedModifiers removeModifier(String id) {
        HashMap<String, SpeedModifier> newMap = new HashMap<String, SpeedModifier>(this.modifiers);
        newMap.remove(id);
        return new SpeedModifiers(Map.copyOf(newMap));
    }

    public boolean hasModifier(String id) {
        return this.modifiers.containsKey(id);
    }

    public record SpeedModifier(String id, float amount, Operation operation) {
        private static final Codec<SpeedModifier> CODEC = RecordCodecBuilder.create(modifier -> modifier.group((App)Codec.STRING.fieldOf("id").forGetter(SpeedModifier::id), (App)Codec.FLOAT.fieldOf("amount").forGetter(SpeedModifier::amount), (App)Operation.CODEC.fieldOf("operation").forGetter(SpeedModifier::operation)).apply((Applicative)modifier, SpeedModifier::new));
    }

    public static enum Operation {
        ADD_BASE,
        MULTIPLY_BASE,
        ADD_TOTAL,
        MULTIPLY_TOTAL;

        private static final Codec<Operation> CODEC;

        static {
            CODEC = Codec.STRING.xmap(Operation::valueOf, Enum::name);
        }
    }
}

